/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.type.Type;

public abstract class RowExpression
{
    public abstract Type getType();

    @Override
    public abstract boolean equals(Object other);
    @Override
    public abstract int hashCode();

    @Override
    public abstract String toString();

    public abstract <C, R> R accept(RowExpressionVisitor<C, R> visitor, C context);
}
