package issues;

import io.jooby.openapi.OpenAPIResult;
import io.jooby.openapi.OpenAPITest;
import issues.i1573.App1573;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class Issue1573 {
  @OpenAPITest(value = App1573.class)
  public void shouldGenerateExpandPaths(OpenAPIResult result) {
    assertEquals("openapi: 3.0.1\n"
        + "info:\n"
        + "  title: 1573 API\n"
        + "  description: 1573 API description\n"
        + "  version: \"1.0\"\n"
        + "paths:\n"
        + "  /profile:\n"
        + "    get:\n"
        + "      operationId: getProfile\n"
        + "      responses:\n"
        + "        \"200\":\n"
        + "          description: Success\n"
        + "          content:\n"
        + "            application/json:\n"
        + "              schema:\n"
        + "                type: string\n"
        + "  /profile/{id}:\n"
        + "    get:\n"
        + "      operationId: getProfileId\n"
        + "      parameters:\n"
        + "      - name: id\n"
        + "        in: path\n"
        + "        required: true\n"
        + "        schema:\n"
        + "          type: string\n"
        + "      responses:\n"
        + "        \"200\":\n"
        + "          description: Success\n"
        + "          content:\n"
        + "            application/json:\n"
        + "              schema:\n"
        + "                type: string\n"
        + "  /c/profile:\n"
        + "    get:\n"
        + "      operationId: profile\n"
        + "      responses:\n"
        + "        \"200\":\n"
        + "          description: Success\n"
        + "          content:\n"
        + "            application/json:\n"
        + "              schema:\n"
        + "                type: string\n"
        + "  /c/profile/{id}:\n"
        + "    get:\n"
        + "      operationId: profile2\n"
        + "      parameters:\n"
        + "      - name: id\n"
        + "        in: path\n"
        + "        required: true\n"
        + "        schema:\n"
        + "          type: string\n"
        + "      responses:\n"
        + "        \"200\":\n"
        + "          description: Success\n"
        + "          content:\n"
        + "            application/json:\n"
        + "              schema:\n"
        + "                type: string\n", result.toYaml());
  }
}
