/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

import java.util.Map;

public class NavigatorHandlerFilterExclude extends AbstractHandler implements IElementUpdater {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NavigatorUtils.filterSelection(HandlerUtil.getCurrentSelection(event), true);
        return null;
    }

    @Override
    public void updateElement(UIElement element, Map parameters)
    {
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider(element.getServiceLocator());
        if (selectionProvider != null) {
            final ISelection selection = selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                final int objectCount = ((IStructuredSelection) selection).size();
                if (objectCount > 1) {
                    element.setText(NLS.bind(UINavigatorMessages.actions_navigator_hide_objects, objectCount));
                } else {
                    DBNNode node = NavigatorUtils.getSelectedNode(selection);
                    if (node != null) {
                        element.setText(NLS.bind(UINavigatorMessages.actions_navigator_hide_object, node.getName()));
                    }
                }
            }
        }
    }

}