/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

import java.util.ArrayList;
import java.util.List;

public class SQLPresentationRegistry
{
    static final String TAG_PRESENTATION = "presentation"; //$NON-NLS-1$

    private static SQLPresentationRegistry instance = null;

    public synchronized static SQLPresentationRegistry getInstance()
    {
        if (instance == null) {
            instance = new SQLPresentationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private final List<SQLPresentationDescriptor> presentations = new ArrayList<>();

    private SQLPresentationRegistry()
    {
    }

    private void loadExtensions(IExtensionRegistry registry)
    {
        IConfigurationElement[] extConfigs = registry.getConfigurationElementsFor(SQLPresentationDescriptor.EXTENSION_ID);
        for (IConfigurationElement ext : extConfigs) {
            // Load functions
            if (TAG_PRESENTATION.equals(ext.getName())) {
                SQLPresentationDescriptor presentationDescriptor = new SQLPresentationDescriptor(ext);
                this.presentations.add(presentationDescriptor);
            }
        }
    }

    public void dispose()
    {
        presentations.clear();
    }

    public List<SQLPresentationDescriptor> getPresentations() {
        return new ArrayList<>(presentations);
    }

    public SQLPresentationDescriptor getPresentation(SQLEditor editor) {
        return presentations.isEmpty() ? null : presentations.get(0);
    }


}
