/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

/**
 * SimpleTypedObject
 */
public class SimpleTypedObject implements DBSTypedObject {

    public static final SimpleTypedObject DEFAULT_TYPE = new SimpleTypedObject("Object");

    private String typeName;

    public SimpleTypedObject(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    public String getFullTypeName() {
        return getTypeName();
    }

    @Override
    public int getTypeID() {
        return 0;
    }

    @Override
    public DBPDataKind getDataKind() {
        return DBPDataKind.OBJECT;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public Integer getPrecision() {
        return null;
    }

    @Override
    public long getMaxLength() {
        return 0;
    }

    @Override
    public long getTypeModifiers() {
        return 0;
    }
}