/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

/**
 * VerticaTableColumn
 */
public class VerticaTableColumn extends GenericTableColumn implements DBPObjectWithLazyDescription {

    private String description;

    VerticaTableColumn(GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPosition, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String defaultValue, boolean autoIncrement) {
        super(table, columnName, typeName, valueType, sourceType, ordinalPosition, columnSize, charLength, scale, precision, radix, notNull, null, defaultValue, autoIncrement, false);
    }

    @Property(viewable = true, editable = true, updatable = true, order = 20, listProvider = ColumnTypeNameListProvider.class)
    @Override
    public String getTypeName()
    {
        return super.getTypeName();
    }

    @Property(viewable = true, editable = true, updatable = true, order = 40)
    @Override
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(viewable = true, editable = true, updatable = true, order = 50)
    @Override
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable = true, editable = true, updatable = true, order = 70)
    @Override
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Nullable
    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String remarks) {
        this.description = remarks;
    }

    @Nullable
    @Override
    @Property(viewable = true, editableExpr = "!object.table.view", updatableExpr = "!object.table.view", length = PropertyLength.MULTILINE, order = 100)
    @LazyProperty(cacheValidator = CommentsValidator.class)
    public String getDescription(DBRProgressMonitor monitor) throws DBException {
        if (description == null) {
            GenericTableBase table = getTable();
            if (table instanceof VerticaTable) {
                ((VerticaTable) table).getDescription(monitor);
            }
        }
        return description;
    }

    // Not supported
    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @Property(viewable = true, editable = true, order = 52)
    public boolean isAutoIncrement() {
        return super.isAutoIncrement();
    }

    public static class CommentsValidator implements IPropertyCacheValidator<VerticaTableColumn> {

        @Override
        public boolean isPropertyCached(VerticaTableColumn object, Object propertyId)
        {
            return object.description != null;
        }
    }
}
