/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;

/**
 * PostgreTable base
 */
public class RedshiftExternalTableColumn extends PostgreTableColumn
{

    public RedshiftExternalTableColumn(RedshiftExternalTable table, boolean persisted) {
        super(table);
        setPersisted(persisted);
    }

    public RedshiftExternalTableColumn(RedshiftExternalTable table, boolean persisted, String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated, String defaultValue) throws DBException {
        super(table);
        setPersisted(persisted);
        setName(name);
        setTypeName(typeName);
        setValueType(valueType);
        setOrdinalPosition(ordinalPosition);
        setMaxLength(maxLength);
        setScale(scale);
        setPrecision(precision);
        setRequired(required);
        setAutoGenerated(autoGenerated);
        setDefaultValue(defaultValue);
    }

    @NotNull
    @Override
    public PostgreDataSource getDataSource() {
        return getTable().getDataSource();
    }

}
