/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jkiss.dbeaver.ext.oceanbase.mysql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

/**
 * OceanbaseView
 */
public class OceanbaseMySQLView extends MySQLView {

    OceanbaseMySQLView(MySQLCatalog catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Override
    public List<MySQLTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List<MySQLTableColumn> childColumns = getContainer().getOceanbaseTableCache().getChildren(monitor,
                getContainer(), this);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        List<MySQLTableColumn> columns = new ArrayList<>(childColumns);
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    @Override
    public MySQLTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName)
            throws DBException {
        return getContainer().getOceanbaseTableCache().getChild(monitor, getContainer(), this, attributeName);
    }

    @Override
    public OceanbaseMySQLCatalog getContainer() {
        return (OceanbaseMySQLCatalog) super.getContainer();
    }

}
