/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2013-2015 Denis Forveille (titou10.titou10@gmail.com)
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.ext.db2.model.fed;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

import java.sql.ResultSet;

/**
 * DB2 Federated Wrapper Option
 * 
 * @author Denis Forveille
 */
public class DB2WrapperOption extends DB2Object<DB2Wrapper> {

    private final DB2Wrapper wrapper;

    private String setting;

    // -----------------------
    // Constructors
    // -----------------------

    public DB2WrapperOption(DB2Wrapper wrapper, ResultSet dbResult)
    {
        super(wrapper, JDBCUtils.safeGetString(dbResult, "OPTION"), true);

        this.wrapper = wrapper;
        this.setting = JDBCUtils.safeGetString(dbResult, "SETTING");
    }

    public DB2Wrapper getWrapper()
    {
        return wrapper;
    }

    // -----------------
    // Properties
    // -----------------

    @NotNull
    @Override
    @Property(viewable = true, editable = false, order = 1)
    public String getName()
    {
        return name;
    }

    @Property(viewable = true, editable = false, order = 2)
    public String getSetting()
    {
        return setting;
    }

}
