/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2023 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages;

import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;

public abstract class DataTransferPageNodeSettings extends ActiveWizardPage<DataTransferWizard> implements IWizardPageNavigable {

    protected DataTransferPageNodeSettings(String pageName) {
        super(pageName);
    }

    @Override
    public boolean isPageNavigable() {
        return true;
    }

    protected boolean isConsumerOfType(Class<? extends IDataTransferConsumer> nodeType) {
        return (getWizard().getSettings().getConsumer() != null &&
            nodeType.isAssignableFrom(getWizard().getSettings().getConsumer().getNodeClass()));
    }

    protected boolean isProducerOfType(Class<? extends IDataTransferProducer> nodeType) {
        return (getWizard().getSettings().getProducer() != null &&
            nodeType.isAssignableFrom(getWizard().getSettings().getProducer().getNodeClass()));
    }

}