lexer grammar OracleKeyword;

import Alphabet;

ACCOUNT
    : A C C O U N T
    ;
    
ADMIN
    : A D M I N
    ;
    
AT
    : A T
    ;
    
AUTHENTICATION
    : A U T H E N T I C A T I O N
    ;
    
BATCH
    : B A T C H
    ;
    
BITMAP
    : B I T M A P
    ;
    
CACHE
    : C A C H E
    ;
    
CASE
    : C A S E
    ;
    
CHECKPOINT
    : C H E C K P O I N T
    ;
    
COMMENT
    : C O M M E N T
    ;
    
CONNECT
    : C O N N E C T
    ;
    
CONSTRAINTS
    : C O N S T R A I N T S
    ;
    
CONTAINER
    : C O N T A I N E R
    ;
    
CONTAINER_DATA
    : C O N T A I N E R UL_ D A T A
    ;
    
CYCLE
    : C Y C L E
    ;
    
DBTIMEZONE
    : D B T I M E Z O N E
    ;
    
DECRYPT
    : D E C R Y P T
    ;
    
DEFERRABLE
    : D E F E R R A B L E
    ;
    
DEFERRED
    : D E F E R R E D
    ;
    
DELEGATE
    : D E L E G A T E
    ;
    
DIRECTORY
    : D I R E C T O R Y
    ;
    
DOUBLE
    : D O U B L E
    ;
    
EDITION
    : E D I T I O N
    ;
    
EDITIONS
    : E D I T I O N S
    ;
    
ELEMENT
    : E L E M E N T
    ;
    
ELSE
    : E L S E
    ;
    
ENCRYPT
    : E N C R Y P T
    ;
    
END
    : E N D
    ;
    
ENTERPRISE
    : E N T E R P R I S E
    ;
    
EXCEPT
    : E X C E P T
    ;
    
EXCEPTIONS
    : E X C E P T I O N S
    ;
    
EXPIRE
    : E X P I R E
    ;
    
EXTERNALLY
    : E X T E R N A L L Y
    ;
    
FORCE
    : F O R C E
    ;
    
GLOBAL
    : G L O B A L
    ;
    
GLOBALLY
    : G L O B A L L Y
    ;
    
HIERARCHY
    : H I E R A R C H Y
    ;
    
IDENTIFIED
    : I D E N T I F I E D
    ;
    
IDENTITY
    : I D E N T I T Y
    ;
    
IMMEDIATE
    : I M M E D I A T E
    ;
    
INCREMENT
    : I N C R E M E N T
    ;
    
INITIALLY
    : I N I T I A L L Y
    ;
    
INTERVAL
    : I N T E R V A L
    ;
    
INTO
    : I N T O
    ;
    
INVALIDATE
    : I N V A L I D A T E
    ;
    
JAVA
    : J A V A
    ;
    
KEEP
    : K E E P
    ;
    
LEVELS
    : L E V E L S
    ;
    
LOCAL
    : L O C A L
    ;
    
LOCK
    : L O C K
    ;
    
MAXVALUE
    : M A X V A L U E
    ;
    
MINING
    : M I N I N G
    ;
    
MINVALUE
    : M I N V A L U E
    ;
    
MODEL
    : M O D E L
    ;
    
MODIFY
    : M O D I F Y
    ;
    
MONTH
    : M O N T H
    ;
    
NAME
    : N A M E
    ;
    
NATIONAL
    : N A T I O N A L
    ;
    
NEW
    : N E W
    ;
    
NOCACHE
    : N O C A C H E
    ;
    
NOCYCLE
    : N O C Y C L E
    ;
    
NOMAXVALUE
    : N O M A X V A L U E
    ;
    
NOMINVALUE
    : N O M I N V A L U E
    ;
    
NONE
    : N O N E
    ;
    
NOORDER
    : N O O R D E R
    ;
    
NORELY
    : N O R E L Y
    ;
    
NOVALIDATE
    : N O V A L I D A T E
    ;
    
NOWAIT
    : N O W A I T
    ;
    
OF
    : O F
    ;
    
ONLY
    : O N L Y
    ;
    
PACKAGE
    : P A C K A G E
    ;
    
PRECISION
    : P R E C I S I O N
    ;
    
PRESERVE
    : P R E S E R V E
    ;
    
PRIOR
    : P R I O R
    ;
    
PROCEDURE
    : P R O C E D U R E
    ;
    
PROFILE
    : P R O F I L E
    ;
    
PUBLIC
    : P U B L I C
    ;
    
QUOTA
    : Q U O T A
    ;
    
REF
    : R E F
    ;
    
REKEY
    : R E K E Y
    ;
    
RELY
    : R E L Y
    ;
    
REMOVE
    : R E M O V E
    ;
    
RENAME
    : R E N A M E
    ;
    
REPLACE
    : R E P L A C E
    ;
    
REQUIRED
    : R E Q U I R E D
    ;
    
RESOURCE
    : R E S O U R C E
    ;
    
ROLES
    : R O L E S
    ;
    
ROWID
    : R O W I D
    ;
    
SALT
    : S A L T
    ;
    
SAVEPOINT
    : S A V E P O I N T
    ;
    
SCOPE
    : S C O P E
    ;
    
SECOND
    : S E C O N D
    ;
    
SEGMENT
    : S E G M E N T
    ;
    
SORT
    : S O R T
    ;
    
SOURCE
    : S O U R C E
    ;
    
SQL
    : S Q L
    ;
    
SQLRF
    : S Q L R F
    ;
    
SUBSTITUTABLE
    : S U B S T I T U T A B L E
    ;
    
TABLESPACE
    : T A B L E S P A C E
    ;
    
TEMPORARY
    : T E M P O R A R Y
    ;
    
THEN
    : T H E N
    ;
    
THROUGH
    : T H R O U G H
    ;
    
TRANSLATION
    : T R A N S L A T I O N
    ;
    
TREAT
    : T R E A T
    ;
    
TYPE
    : T Y P E
    ;
    
UNLIMITED
    : U N L I M I T E D
    ;
    
UNLOCK
    : U N L O C K
    ;
    
UNUSED
    : U N U S E D
    ;
    
USE
    : U S E
    ;
    
USERS
    : U S E R S
    ;
    
USING
    : U S I N G
    ;
    
VALIDATE
    : V A L I D A T E
    ;
    
VALUE
    : V A L U E
    ;
    
VARYING
    : V A R Y I N G
    ;
    
VIRTUAL
    : V I R T U A L
    ;
    
WAIT
    : W A I T
    ;
    
WHEN
    : W H E N
    ;
    
WRITE
    : W R I T E
    ;
    
ZONE
    : Z O N E
    ;
