/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.core.masterslave;

import org.apache.shardingsphere.core.masterslave.impl.RandomMasterSlaveLoadBalanceAlgorithm;
import org.apache.shardingsphere.core.masterslave.impl.RoundRobinMasterSlaveLoadBalanceAlgorithm;
import org.junit.Test;

import java.util.Properties;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.junit.Assert.assertThat;

public final class MasterSlaveLoadBalanceAlgorithmFactoryTest {
    
    @Test
    public void assertNewRoundRobinMasterSlaveLoadBalanceAlgorithm() {
        assertThat(MasterSlaveLoadBalanceAlgorithmFactory.getInstance().newAlgorithm("ROUND_ROBIN", new Properties()), instanceOf(RoundRobinMasterSlaveLoadBalanceAlgorithm.class));
    }
    
    @Test
    public void assertNewRandomMasterSlaveLoadBalanceAlgorithm() {
        assertThat(MasterSlaveLoadBalanceAlgorithmFactory.getInstance().newAlgorithm("RANDOM", new Properties()), instanceOf(RandomMasterSlaveLoadBalanceAlgorithm.class));
    }
    
    @Test
    public void assertNewDefaultMasterSlaveLoadBalanceAlgorithm() {
        assertThat(MasterSlaveLoadBalanceAlgorithmFactory.getInstance().newAlgorithm(), instanceOf(RoundRobinMasterSlaveLoadBalanceAlgorithm.class));
    }
}
