/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.core.parsing.parser.clause.facade;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.shardingsphere.core.parsing.parser.clause.InsertColumnsClauseParser;
import org.apache.shardingsphere.core.parsing.parser.clause.InsertDuplicateKeyUpdateClauseParser;
import org.apache.shardingsphere.core.parsing.parser.clause.InsertIntoClauseParser;
import org.apache.shardingsphere.core.parsing.parser.clause.InsertSetClauseParser;
import org.apache.shardingsphere.core.parsing.parser.clause.InsertValuesClauseParser;

/**
 * Insert clause parser facade.
 *
 * @author zhangliang
 */
@RequiredArgsConstructor
@Getter
public abstract class AbstractInsertClauseParserFacade {
    
    private final InsertIntoClauseParser insertIntoClauseParser;
    
    private final InsertColumnsClauseParser insertColumnsClauseParser;
    
    private final InsertValuesClauseParser insertValuesClauseParser;
    
    private final InsertSetClauseParser insertSetClauseParser;
    
    private final InsertDuplicateKeyUpdateClauseParser insertDuplicateKeyUpdateClauseParser;
}
