/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.core.parsing.antlr.sql.segment;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import org.apache.shardingsphere.core.parsing.lexer.token.DefaultKeyword;

import java.util.LinkedList;
import java.util.List;

/**
 * Insert values segment.
 *
 * @author duhongjun
 * @author panjuan
 */
@RequiredArgsConstructor
@Getter
public final class InsertValuesSegment implements SQLSegment {
    
    private final DefaultKeyword type;
    
    private final int startIndex;
    
    private final int stopIndex;
    
    private final int parametersCount;
    
    private final List<CommonExpressionSegment> values = new LinkedList<>();
}
