/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnit5TestRunnerUtil {
    private static final String[] DISABLED_ANNO = new String[]{"org.junit.jupiter.api.Disabled"};
    private static final String[] DISABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.DisabledOnJre", "org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.DisabledIfSystemProperty", "org.junit.jupiter.api.condition.DisabledOnOs"};
    private static final String[] ENABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.EnabledOnJre", "org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.EnabledIfSystemProperty", "org.junit.jupiter.api.condition.EnabledOnOs"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LauncherDiscoveryRequest buildRequest(String[] suiteClassNames, String[] packageNameRef) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        if (suiteClassNames.length == 1 && suiteClassNames[0].charAt(0) == '@') {
            try (BufferedReader reader = new BufferedReader(new FileReader(suiteClassNames[0].substring(1)));){
                String line;
                String packageName = reader.readLine();
                if (packageName == null) {
                    LauncherDiscoveryRequest launcherDiscoveryRequest = null;
                    return launcherDiscoveryRequest;
                }
                String tags = reader.readLine();
                String filters = reader.readLine();
                ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
                while ((line = reader.readLine()) != null) {
                    DiscoverySelector selector = JUnit5TestRunnerUtil.createSelector(line);
                    if (selector == null) continue;
                    selectors.add(selector);
                }
                packageNameRef[0] = packageName.length() == 0 ? "<default package>" : packageName;
                builder = selectors.isEmpty() ? builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)packageName)}) : builder.selectors(selectors);
                if (filters != null && !filters.isEmpty()) {
                    builder = builder.filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])filters.split("\\|\\|"))});
                }
                if (tags != null && !tags.isEmpty()) {
                    builder = builder.filters(new Filter[]{TagFilter.includeTags((String[])tags.split(" "))});
                }
                LauncherDiscoveryRequest launcherDiscoveryRequest = builder.filters(new Filter[]{ClassNameFilter.excludeClassNamePatterns((String[])new String[]{"com\\.intellij\\.rt.*", "com\\.intellij\\.junit3.*"})}).build();
                return launcherDiscoveryRequest;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
                return null;
            }
        }
        String disableDisabledCondition = JUnit5TestRunnerUtil.getDisabledConditionValue(suiteClassNames[0]);
        if (disableDisabledCondition != null) {
            builder = builder.configurationParameter("junit.jupiter.conditions.deactivate", disableDisabledCondition);
        }
        DiscoverySelector selector = JUnit5TestRunnerUtil.createSelector(suiteClassNames[0]);
        assert (selector != null) : "selector by class name is never null";
        return builder.selectors(new DiscoverySelector[]{selector}).build();
    }

    public static String getDisabledConditionValue(String name) {
        int commaIdx = name.indexOf(",");
        String className = name.substring(0, commaIdx < 0 ? name.length() : commaIdx);
        String methodName = commaIdx > 0 ? name.substring(commaIdx + 1) : null;
        try {
            ClassLoader loader = JUnit5TestRunnerUtil.class.getClassLoader();
            Class<?> testClass = Class.forName(className, false, loader);
            String disabledCondition = JUnit5TestRunnerUtil.getDisabledCondition(loader, testClass);
            if (disabledCondition != null) {
                return disabledCondition;
            }
            if (methodName != null) {
                Method m;
                int paramIdx = methodName.indexOf("(");
                if (paramIdx < 0) {
                    m = testClass.getDeclaredMethod(methodName, new Class[0]);
                } else {
                    if (!methodName.endsWith(")")) {
                        return null;
                    }
                    String paramsString = methodName.substring(paramIdx + 1, methodName.length() - 1);
                    String[] params = paramsString.split(",");
                    Class[] paramTypes = new Class[params.length];
                    for (int i = 0; i < params.length; ++i) {
                        paramTypes[i] = Class.forName(params[i], false, loader);
                    }
                    m = testClass.getDeclaredMethod(methodName.substring(0, paramIdx), paramTypes);
                }
                disabledCondition = JUnit5TestRunnerUtil.getDisabledCondition(loader, m);
                if (disabledCondition != null) {
                    return disabledCondition;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getDisabledCondition(ClassLoader loader, AnnotatedElement annotatedElement) throws ClassNotFoundException {
        if (JUnit5TestRunnerUtil.isDisabledCondition(DISABLED_COND_ANNO, loader, annotatedElement)) {
            return "org.junit.*Disabled*Condition";
        }
        if (JUnit5TestRunnerUtil.isDisabledCondition(ENABLED_COND_ANNO, loader, annotatedElement)) {
            return "org.junit.*Enabled*Condition";
        }
        if (JUnit5TestRunnerUtil.isDisabledCondition(DISABLED_ANNO, loader, annotatedElement)) {
            return "org.junit.*DisabledCondition";
        }
        return null;
    }

    private static boolean isDisabledCondition(String[] anno, ClassLoader loader, AnnotatedElement annotatedElement) throws ClassNotFoundException {
        for (String disabledAnnotationName : anno) {
            Class<?> disabledAnnotation = Class.forName(disabledAnnotationName, false, loader);
            if (!AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, disabledAnnotation).isPresent()) continue;
            return true;
        }
        return false;
    }

    protected static DiscoverySelector createSelector(String line) {
        if (line.startsWith("\u001b")) {
            String uniqueId = line.substring("\u001b".length());
            return DiscoverySelectors.selectUniqueId((String)uniqueId);
        }
        if (line.startsWith("+")) {
            String directory = line.substring("+".length());
            List selectors = DiscoverySelectors.selectClasspathRoots(Collections.singleton(Paths.get(directory, new String[0])));
            if (selectors.isEmpty()) {
                return null;
            }
            return (DiscoverySelector)selectors.iterator().next();
        }
        if (line.contains(",")) {
            return DiscoverySelectors.selectMethod((String)line.replaceFirst(",", "#"));
        }
        return DiscoverySelectors.selectClass((String)line);
    }
}

