/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.tabs.TabInfo;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionEditor;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return file instanceof TerminalSessionVirtualFileImpl;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) != null) {
            return new TerminalSessionEditor(project, (TerminalSessionVirtualFileImpl)file);
        }
        TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)file;
        JBTerminalWidget widget = terminalFile.getTerminalWidget();
        TabInfo tabInfo = new TabInfo((JComponent)widget).setText(terminalFile.getName());
        TerminalTabState tts = new TerminalTabState();
        tts.myWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, file.getName());
        LocalTerminalDirectRunner runner = LocalTerminalDirectRunner.createTerminalRunner(project);
        JBTerminalWidget newWidget = TerminalUtil.createTerminal(runner, tts, null);
        TerminalSessionVirtualFileImpl newSessionVirtualFile = new TerminalSessionVirtualFileImpl(tabInfo, newWidget, terminalFile.getSettingsProvider());
        tabInfo.setObject((Object)newSessionVirtualFile);
        TerminalSessionEditor editor = new TerminalSessionEditor(project, newSessionVirtualFile);
        newWidget.moveDisposable((Disposable)editor);
        return editor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "terminal-session-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

