/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.login.IUserPropertyCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

public class GoogleLoginUtils {
    public static final Logger LOG = Logger.getInstance(GoogleLoginUtils.class);
    public static final int DEFAULT_PICTURE_SIZE = 96;
    private static final Pattern FIFE_AVATAR_URL = Pattern.compile("lh.*(googleusercontent|google)\\.com");

    public static void provideUserPicture(@NotNull Userinfoplus userInfo, @NotNull Consumer<Image> pictureCallback) {
        URL newUrl = GoogleLoginUtils.appendSizeParameter(userInfo.getPicture());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                pictureCallback.accept(ImageIO.read(newUrl));
            }
            catch (IOException exception) {
                pictureCallback.accept(null);
            }
        });
    }

    @VisibleForTesting
    @NotNull
    static URL appendSizeParameter(@NotNull String url) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (FIFE_AVATAR_URL.matcher(url).find() && (url.contains("/a/") || url.contains("/a-"))) {
                uriBuilder.setPath(uriBuilder.getPath() + "=s" + 96 + "-c");
            } else {
                uriBuilder.addParameter("sz", String.valueOf(96));
            }
            return uriBuilder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public static void getUserInfo(@NotNull Credential credential, @NotNull IUserPropertyCallback<? super Userinfoplus> callback) {
        Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credential).setApplicationName("Android Studio").build();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Userinfoplus userInfo = null;
            try {
                userInfo = (Userinfoplus)userInfoService.userinfo().get().execute();
            }
            catch (IOException e) {
                LOG.warn("Error retrieving user information.", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.warn("Error retrieving user information.", e);
            }
            if (userInfo != null && userInfo.getId() != null) {
                callback.setProperty(userInfo);
            } else {
                callback.setProperty(null);
            }
        });
    }

    public static void showErrorDialog(@NotNull String message, @NotNull String title) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Messages.showErrorDialog((String)message, (String)title);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)message, (String)title), ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public static Credential makeFakeUserCredential() {
        String clientId = System.getenv().get("ANDROID_CLIENT_ID");
        String clientSecret = System.getenv().get("ANDROID_CLIENT_SECRET");
        String refreshToken = System.getenv().get("FAKE_USER_REFRESH_TOKEN");
        String accessToken = System.getenv().get("FAKE_USER_ACCESS_TOKEN");
        GoogleCredential cred = new GoogleCredential.Builder().setJsonFactory((JsonFactory)new JacksonFactory()).setTransport((HttpTransport)new NetHttpTransport()).setClientSecrets(clientId, clientSecret).build();
        cred.setAccessToken(accessToken);
        cred.setRefreshToken(refreshToken);
        return cred;
    }
}

