/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveValueDescriptor
extends InstanceValueDescriptor {
    PrimitiveValueDescriptor(@NotNull Project project, @Nullable Value value) {
        super(project, value);
    }

    public String calcValueName() {
        Value value = this.getValue();
        if (value == null) {
            return "value";
        }
        if (value instanceof ObjectReference) {
            return super.calcValueName();
        }
        return value.type().name();
    }

    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            return super.getDescriptorEvaluation(debuggerContext);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        return elementFactory.createExpressionFromText(value.toString(), ContextUtil.getContextElement((StackFrameContext)debuggerContext));
    }
}

