/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.test;

import com.intellij.debugger.DebuggerTestCase;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.OutputChecker;
import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.lib.impl.StandardLibrarySupportProvider;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.resolve.ResolvedStreamChain;
import com.intellij.debugger.streams.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.TraceResultInterpreter;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.sun.jdi.Value;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import junit.framework.TestCase;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SkipSlowTestLocally
public abstract class TraceExecutionTestCase
extends DebuggerTestCase {
    private static final ChainSelector DEFAULT_CHAIN_SELECTOR = ChainSelector.byIndex(0);
    private static final LibrarySupportProvider DEFAULT_LIBRARY_SUPPORT_PROVIDER = new StandardLibrarySupportProvider();
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());
    private final DebuggerPositionResolver myPositionResolver = new DebuggerPositionResolverImpl();

    protected OutputChecker initOutputChecker() {
        return new OutputChecker(this.getTestAppPath(), this.getAppOutputPath()){

            protected String replaceAdditionalInOutput(String str) {
                return TraceExecutionTestCase.this.replaceAdditionalInOutput(super.replaceAdditionalInOutput(str));
            }
        };
    }

    @NotNull
    protected String replaceAdditionalInOutput(@NotNull String str) {
        return str;
    }

    protected LibrarySupportProvider getLibrarySupportProvider() {
        return DEFAULT_LIBRARY_SUPPORT_PROVIDER;
    }

    protected String getTestAppPath() {
        return new File(PluginPathManager.getPluginHomePath((String)"stream-debugger") + "/testData/debug/").getAbsolutePath();
    }

    protected void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Throwable t) {
                if (t.getMessage().startsWith("Thread leaked: Thread[")) break block2;
                throw t;
            }
        }
    }

    protected void doTest(boolean isResultNull) {
        this.doTest(isResultNull, DEFAULT_CHAIN_SELECTOR);
    }

    protected void doTest(boolean isResultNull, @NotNull String className) {
        this.doTest(isResultNull, className, DEFAULT_CHAIN_SELECTOR);
    }

    protected void doTest(boolean isResultNull, @NotNull ChainSelector chainSelector) {
        String className = this.getTestName(false);
        this.doTest(isResultNull, className, chainSelector);
    }

    protected void doTest(boolean isResultNull, @NotNull String className, @NotNull ChainSelector chainSelector) {
        try {
            this.doTestImpl(isResultNull, className, chainSelector);
        }
        catch (Exception e) {
            throw new AssertionError("exception thrown", e);
        }
    }

    private void doTestImpl(final boolean isResultNull, @NotNull String className, final @NotNull ChainSelector chainSelector) throws ExecutionException {
        this.LOG.info("Test started: " + this.getTestName(false));
        this.createLocalProcess(className);
        final XDebugSession session = this.getDebuggerSession().getXDebugSession();
        TraceExecutionTestCase.assertNotNull((Object)session);
        final AtomicBoolean completed = new AtomicBoolean(false);
        final DebuggerPositionResolver positionResolver = this.getPositionResolver();
        final StreamChainBuilder chainBuilder = this.getChainBuilder();
        final TraceResultInterpreter resultInterpreter = this.getResultInterpreter();
        final TraceExpressionBuilder expressionBuilder = this.getExpressionBuilder();
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                if (completed.getAndSet(true)) {
                    this.resume();
                    return;
                }
                try {
                    this.sessionPausedImpl();
                }
                catch (Throwable t) {
                    TraceExecutionTestCase.this.println("Exception caught: " + t + ", " + t.getMessage(), ProcessOutputTypes.SYSTEM);
                    t.printStackTrace();
                    this.resume();
                }
            }

            private void sessionPausedImpl() {
                TraceExecutionTestCase.this.printContext((StackFrameContext)TraceExecutionTestCase.this.getDebugProcess().getDebuggerContext());
                final StreamChain chain = (StreamChain)ApplicationManager.getApplication().runReadAction(() -> {
                    PsiElement elementAtBreakpoint = positionResolver.getNearestElementToBreakpoint(session);
                    List<StreamChain> chains = elementAtBreakpoint == null ? null : chainBuilder.build(elementAtBreakpoint);
                    return chains == null || chains.isEmpty() ? null : chainSelector.select(chains);
                });
                if (chain == null) {
                    this.complete(null, null, null, FailureReason.CHAIN_CONSTRUCTION);
                    return;
                }
                new EvaluateExpressionTracer(session, expressionBuilder, resultInterpreter).trace(chain, new TracingCallback(){

                    @Override
                    public void evaluated(@NotNull TracingResult result, @NotNull EvaluationContextImpl context) {
                        this.complete(chain, result, null, null);
                    }

                    @Override
                    public void evaluationFailed(@NotNull String traceExpression, @NotNull String message) {
                        this.complete(chain, null, message, FailureReason.EVALUATION);
                    }

                    @Override
                    public void compilationFailed(@NotNull String traceExpression, @NotNull String message) {
                        TraceExecutionTestCase.this.LOG.warn("[" + TraceExecutionTestCase.this.getTestName(false) + "] Compilation failed.");
                        this.complete(chain, null, message, FailureReason.COMPILATION);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void complete(@Nullable StreamChain chain, @Nullable TracingResult result, @Nullable String error, @Nullable FailureReason errorReason) {
                try {
                    if (error != null) {
                        TestCase.assertNotNull((Object)((Object)errorReason));
                        TestCase.assertNotNull((Object)chain);
                        TraceExecutionTestCase.this.handleError(chain, error, errorReason);
                    } else {
                        TestCase.assertNull((Object)((Object)errorReason));
                        TraceExecutionTestCase.this.handleSuccess(chain, result, isResultNull);
                    }
                }
                catch (Throwable t) {
                    TraceExecutionTestCase.this.println("Exception caught: " + t + ", " + t.getMessage(), ProcessOutputTypes.SYSTEM);
                }
                finally {
                    this.resume();
                }
            }

            private void resume() {
                ApplicationManager.getApplication().invokeLater(() -> ((XDebugSession)session).resume());
            }
        }, this.getTestRootDisposable());
    }

    protected DebuggerPositionResolver getPositionResolver() {
        return this.myPositionResolver;
    }

    protected TraceResultInterpreter getResultInterpreter() {
        return new TraceResultInterpreterImpl(this.getLibrarySupportProvider().getLibrarySupport().getInterpreterFactory());
    }

    protected StreamChainBuilder getChainBuilder() {
        return this.getLibrarySupportProvider().getChainBuilder();
    }

    protected TraceExpressionBuilder getExpressionBuilder() {
        return this.getLibrarySupportProvider().getExpressionBuilder(this.getProject());
    }

    protected void handleError(@NotNull StreamChain chain, @NotNull String error, @NotNull FailureReason reason) {
        TraceExecutionTestCase.fail((String)error);
    }

    protected void handleSuccess(@Nullable StreamChain chain, @Nullable TracingResult result, boolean resultMustBeNull) {
        TraceExecutionTestCase.assertNotNull((Object)chain);
        TraceExecutionTestCase.assertNotNull((Object)result);
        this.println(chain.getText(), ProcessOutputTypes.SYSTEM);
        TraceElement resultValue = result.getResult();
        this.handleResultValue(resultValue.getValue(), resultMustBeNull);
        List<TraceInfo> trace = result.getTrace();
        this.handleTrace(trace);
        ResolvedTracingResult resolvedTrace = result.resolve(this.getLibrarySupportProvider().getLibrarySupport().getResolverFactory());
        this.handleResolvedTrace(resolvedTrace);
    }

    protected void handleResultValue(@Nullable Value result, boolean mustBeNull) {
        if (mustBeNull) {
            TraceExecutionTestCase.assertNull((Object)result);
        } else {
            TraceExecutionTestCase.assertNotNull((Object)result);
        }
    }

    protected void handleTrace(@NotNull List<TraceInfo> trace) {
        for (TraceInfo info : trace) {
            String name = info.getCall().getName();
            this.println(name, ProcessOutputTypes.SYSTEM);
            this.print("    before: ", ProcessOutputTypes.SYSTEM);
            Map<Integer, TraceElement> before = info.getValuesOrderBefore();
            this.println(TraceExecutionTestCase.traceToString(before.values()), ProcessOutputTypes.SYSTEM);
            this.print("    after: ", ProcessOutputTypes.SYSTEM);
            Map<Integer, TraceElement> after = info.getValuesOrderAfter();
            this.println(TraceExecutionTestCase.traceToString(after.values()), ProcessOutputTypes.SYSTEM);
        }
    }

    protected void handleResolvedTrace(@NotNull ResolvedTracingResult result) {
        ResolvedStreamChain resolvedChain = result.getResolvedChain();
        TraceExecutionTestCase.checkChain(resolvedChain);
        TraceExecutionTestCase.checkTracesIsCorrectInBothDirections(resolvedChain);
        ResolvedStreamCall.Terminator terminator = resolvedChain.getTerminator();
        resolvedChain.getIntermediateCalls().forEach(x -> this.printBeforeAndAfterValues(x.getStateBefore(), x.getStateAfter()));
        this.printBeforeAndAfterValues(terminator.getStateBefore(), (PrevAwareState)terminator.getStateAfter());
    }

    private void printBeforeAndAfterValues(@Nullable NextAwareState before, @Nullable PrevAwareState after) {
        TraceExecutionTestCase.assertFalse((before == null && after == null ? 1 : 0) != 0);
        StreamCall call2 = before == null ? after.getPrevCall() : before.getNextCall();
        TraceExecutionTestCase.assertNotNull((Object)call2);
        this.println("mappings for " + call2.getName(), ProcessOutputTypes.SYSTEM);
        this.println("  direct:", ProcessOutputTypes.SYSTEM);
        if (before != null) {
            this.printMapping(before.getTrace(), before::getNextValues, Direction.FORWARD);
        } else {
            this.println("    no", ProcessOutputTypes.SYSTEM);
        }
        this.println("  reverse:", ProcessOutputTypes.SYSTEM);
        if (after != null) {
            this.printMapping(after.getTrace(), after::getPrevValues, Direction.BACKWARD);
        } else {
            this.println("    not found", ProcessOutputTypes.SYSTEM);
        }
    }

    private void printMapping(@NotNull List<TraceElement> values, @NotNull Function<? super TraceElement, ? extends List<TraceElement>> mapper, @NotNull Direction direction) {
        if (values.isEmpty()) {
            this.println("    empty", ProcessOutputTypes.SYSTEM);
        }
        for (TraceElement element : values) {
            List<TraceElement> mappedValues = mapper.apply(element);
            String mapped = TraceExecutionTestCase.traceToString(mappedValues);
            String line = Direction.FORWARD.equals((Object)direction) ? element.getTime() + " -> " + mapped : mapped + " <- " + element.getTime();
            this.println("    " + line, ProcessOutputTypes.SYSTEM);
        }
    }

    private static void checkChain(@NotNull ResolvedStreamChain chain) {
        List<ResolvedStreamCall.Intermediate> intermediates = chain.getIntermediateCalls();
        ResolvedStreamCall.Terminator terminator = chain.getTerminator();
        if (intermediates.isEmpty()) {
            TraceExecutionTestCase.assertFalse((boolean)(terminator.getStateBefore() instanceof PrevAwareState));
        }
        TraceExecutionTestCase.checkIntermediates(chain.getIntermediateCalls());
        TraceExecutionTestCase.assertEquals((String)((TerminatorStreamCall)terminator.getCall()).getName(), (String)terminator.getStateBefore().getNextCall().getName());
        PrevAwareState after = (PrevAwareState)terminator.getStateAfter();
        if (after != null) {
            StreamCall terminatorCall = after.getPrevCall();
            TraceExecutionTestCase.assertNotNull((Object)terminatorCall);
            TraceExecutionTestCase.assertEquals((String)((TerminatorStreamCall)terminator.getCall()).getName(), (String)terminatorCall.getName());
        }
        if (!intermediates.isEmpty()) {
            ResolvedStreamCall.Intermediate lastIntermediate = intermediates.get(intermediates.size() - 1);
            PrevAwareState stateAfterIntermediates = lastIntermediate.getStateAfter();
            TraceExecutionTestCase.assertInstanceOf((Object)stateAfterIntermediates, NextAwareState.class);
            TraceExecutionTestCase.assertEquals((String)((TerminatorStreamCall)terminator.getCall()).getName(), (String)((NextAwareState)((Object)stateAfterIntermediates)).getNextCall().getName());
        }
    }

    private static void checkIntermediates(@NotNull List<ResolvedStreamCall.Intermediate> intermediates) {
        for (int i = 0; i < intermediates.size() - 1; ++i) {
            ResolvedStreamCall.Intermediate prev = intermediates.get(i);
            ResolvedStreamCall.Intermediate next = intermediates.get(i + 1);
            TraceExecutionTestCase.assertSame((Object)prev.getStateAfter(), (Object)next.getStateBefore());
            StreamCall prevCall = prev.getStateAfter().getPrevCall();
            TraceExecutionTestCase.assertNotNull((Object)prevCall);
            TraceExecutionTestCase.assertEquals((String)((IntermediateStreamCall)prev.getCall()).getName(), (String)prevCall.getName());
            TraceExecutionTestCase.assertEquals((String)((IntermediateStreamCall)next.getCall()).getName(), (String)next.getStateBefore().getNextCall().getName());
        }
    }

    private static void checkTracesIsCorrectInBothDirections(@NotNull ResolvedStreamChain resolvedChain) {
        for (ResolvedStreamCall.Intermediate intermediate : resolvedChain.getIntermediateCalls()) {
            TraceExecutionTestCase.checkNeighborTraces(intermediate.getStateBefore(), intermediate.getStateAfter());
        }
        ResolvedStreamCall.Terminator terminator = resolvedChain.getTerminator();
        PrevAwareState after = (PrevAwareState)terminator.getStateAfter();
        if (after != null) {
            TraceExecutionTestCase.checkNeighborTraces(terminator.getStateBefore(), after);
        }
    }

    private static void checkNeighborTraces(@NotNull NextAwareState left, @NotNull PrevAwareState right) {
        HashSet<TraceElement> leftValues = new HashSet<TraceElement>(left.getTrace());
        HashSet<TraceElement> rightValues = new HashSet<TraceElement>(right.getTrace());
        TraceExecutionTestCase.checkThatMappingsIsCorrect(leftValues, rightValues, left::getNextValues, right::getPrevValues);
        TraceExecutionTestCase.checkThatMappingsIsCorrect(rightValues, leftValues, right::getPrevValues, left::getNextValues);
    }

    private static void checkThatMappingsIsCorrect(@NotNull Set<TraceElement> prev, @NotNull Set<TraceElement> next, @NotNull Function<? super TraceElement, ? extends List<TraceElement>> toNext, @NotNull Function<? super TraceElement, ? extends List<TraceElement>> toPrev) {
        for (TraceElement leftElement : prev) {
            List<TraceElement> mapToRight = toNext.apply(leftElement);
            for (TraceElement rightElement : mapToRight) {
                TraceExecutionTestCase.assertTrue((boolean)next.contains(rightElement));
                TraceExecutionTestCase.assertTrue((boolean)toPrev.apply(rightElement).contains(leftElement));
            }
        }
    }

    @NotNull
    private static String traceToString(@NotNull Collection<TraceElement> trace) {
        return TraceExecutionTestCase.replaceIfEmpty(((StreamEx)StreamEx.of(trace).map(TraceElement::getTime).sorted()).joining((CharSequence)","));
    }

    @NotNull
    private static String replaceIfEmpty(@NotNull String str) {
        return str.isEmpty() ? "nothing" : str;
    }

    @FunctionalInterface
    protected static interface ChainSelector {
        @NotNull
        public StreamChain select(@NotNull List<StreamChain> var1);

        public static ChainSelector byIndex(int index) {
            return chains -> (StreamChain)chains.get(index);
        }
    }

    protected static enum FailureReason {
        COMPILATION,
        EVALUATION,
        CHAIN_CONSTRUCTION;

    }

    private static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

