/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiUtil {
    private StreamApiUtil() {
    }

    public static boolean isStreamCall(@NotNull PsiMethodCallExpression expression) {
        return StreamApiUtil.isIntermediateStreamCall(expression) || StreamApiUtil.isProducerStreamCall(expression) || StreamApiUtil.isTerminationStreamCall(expression);
    }

    public static boolean isProducerStreamCall(@NotNull PsiMethodCallExpression expression) {
        PsiMethod method = expression.resolveMethod();
        return method != null && method.hasModifierProperty("static") || StreamApiUtil.checkStreamCall(expression, false, true);
    }

    public static boolean isIntermediateStreamCall(@NotNull PsiMethodCallExpression expression) {
        return StreamApiUtil.checkStreamCall(expression, true, true);
    }

    public static boolean isTerminationStreamCall(@NotNull PsiMethodCallExpression expression) {
        return StreamApiUtil.checkStreamCall(expression, true, false);
    }

    private static boolean checkStreamCall(@NotNull PsiMethodCallExpression expression, boolean mustReceiverBeStream, boolean mustResultBeStream) {
        PsiElement methodClass;
        PsiMethod method = expression.resolveMethod();
        if (method != null && mustResultBeStream == StreamApiUtil.isStreamType(expression.getType()) && (methodClass = method.getParent()) instanceof PsiClass) {
            if (mustReceiverBeStream && method.hasModifier(JvmModifier.STATIC)) {
                return false;
            }
            return mustReceiverBeStream == StreamApiUtil.isStreamType((PsiClass)methodClass);
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isStreamType(@Nullable PsiType psiType) {
        return InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.stream.BaseStream");
    }

    @Contract(value="null -> false")
    private static boolean isStreamType(@Nullable PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.BaseStream");
    }
}

