/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CidrFileBasedChangeTestFixture;
import com.jetbrains.cidr.lang.CidrFileBasedCompletionTestFixture;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.fixtures.OCClangdCodeInsightTestCase;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class OCCompletionResultTestCase
extends OCClangdCodeInsightTestCase {
    protected final OCLanguageKind myDefaultLanguageKind;
    protected CidrFileBasedChangeTestFixture myFileBasedChangeTestFixture;
    protected boolean myClangdOn = false;
    protected CidrFormattingFixture myFormattingFixture;

    @Override
    protected void startClangdIfNeeded(@NotNull Project project2) {
        if (this.myClangdOn) {
            super.startClangdIfNeeded(project2);
            return;
        }
        ClangUtils.forceClangdOff((Project)project2);
        ClangUtils.forceClangdShowErrorsOff((Project)project2);
    }

    @Override
    protected boolean isLegacyTest() {
        return !this.myClangdOn;
    }

    public OCCompletionResultTestCase(OCLanguageKind languageKind, String dataDir) {
        super(dataDir, languageKind.getDefaultSourceExtension());
        this.myDefaultLanguageKind = languageKind;
    }

    protected final void doTest() throws Exception {
        this.doTest(this.myDefaultLanguageKind);
    }

    protected void doTest(OCLanguageKind languageKind) throws Exception {
        this.myFileBasedChangeTestFixture.doTest(this.myCodeInsightFixture.getFullFileName(this.getTestName(false), '.' + languageKind.getDefaultSourceExtension()));
    }

    protected void doTestCMake() throws Exception {
        this.myFileBasedChangeTestFixture.doTest(this.myCodeInsightFixture.getFullFileName(this.getTestName(false), ".cmake"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFileBasedChangeTestFixture = this.createTestFixture();
        this.myFileBasedChangeTestFixture.setUp();
        this.myFormattingFixture.wrapBodyIntoBraces();
        this.getProject().putUserData(CallableInsertUtils.ENABLED_PLACEHOLDERS_IN_TESTS, (Object)false);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFileBasedChangeTestFixture.tearDown();
            this.getProject().putUserData(CallableInsertUtils.ENABLED_PLACEHOLDERS_IN_TESTS, null);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture(this.myCodeInsightFixture);
    }

    @Override
    public String getLangTestDataPath() {
        return new File(super.getLangTestDataPath(), "completion/result/").getPath();
    }

    protected CidrFileBasedChangeTestFixture createTestFixture() {
        return new CidrFileBasedCompletionTestFixture(this.myCodeInsightFixture, this.myProjectFixture, "//");
    }
}

