/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class MavenDependencyUtil {
    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates) {
        MavenDependencyUtil.addFromMaven(model, mavenCoordinates, true);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates, boolean includeTransitiveDependencies) {
        MavenDependencyUtil.addFromMaven(model, mavenCoordinates, includeTransitiveDependencies, DependencyScope.COMPILE);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates, boolean includeTransitiveDependencies, DependencyScope dependencyScope) {
        List<RemoteRepositoryDescription> remoteRepositoryDescriptions = MavenDependencyUtil.getRemoteRepositoryDescriptions();
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates, includeTransitiveDependencies);
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)model.getProject(), (RepositoryLibraryProperties)libraryProperties, (boolean)false, (boolean)false, null, remoteRepositoryDescriptions);
        LibraryTable.ModifiableModel tableModel = model.getModuleLibraryTable().getModifiableModel();
        Library library = tableModel.createLibrary(mavenCoordinates);
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        if (roots.isEmpty()) {
            throw new IllegalStateException(String.format("No roots for '%s'", mavenCoordinates));
        }
        for (OrderRoot root : roots) {
            libraryModel.addRoot(root.getFile(), root.getType());
        }
        LibraryOrderEntry libraryOrderEntry = model.findLibraryOrderEntry(library);
        if (libraryOrderEntry == null) {
            throw new IllegalStateException("Unable to find registered library " + mavenCoordinates);
        }
        libraryOrderEntry.setScope(dependencyScope);
        libraryModel.commit();
        tableModel.commit();
    }

    @NotNull
    private static List<RemoteRepositoryDescription> getRemoteRepositoryDescriptions() {
        return ContainerUtil.map((Collection)IntelliJProjectConfiguration.getRemoteRepositoryDescriptions(), repository -> new RemoteRepositoryDescription(repository.getId(), repository.getName(), repository.getUrl()));
    }
}

