/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.impldep.org.apache.commons.lang.WordUtils;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.plugins.PlayPluginConfigurations;

@Incubating
@Deprecated
public class PlayTestPlugin
extends RuleSource {
    @Mutate
    void createTestTasks(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> playBinaries, PlayPluginConfigurations configurations, ProjectLayout projectLayout, ProjectIdentifier projectIdentifier, @Path(value="buildDir") File buildDir) {
        DeprecationLogger.deprecatePlugin("Play Test").replaceWithExternalPlugin("org.gradle.playframework-test").willBeRemovedInGradle7().withUserManual("play_plugin").nagUser();
        for (PlayApplicationBinarySpecInternal binary : playBinaries) {
            FileCollection binaryOutputs = projectLayout.files(binary.getJarFile());
            FileCollection testCompileClasspath = binaryOutputs.plus(configurations.getPlayTest().getAllArtifacts());
            String testCompileTaskName = binary.getTasks().taskName("compile", "tests");
            Directory testSourceDir = projectLayout.getProjectDirectory().dir("test");
            FileTree testSources = testSourceDir.getAsFileTree().matching(new PatternSet().include("**/*.scala", "**/*.java"));
            Provider<Directory> testClassesDir = projectLayout.getBuildDirectory().dir(binary.getProjectScopedName() + "/testClasses");
            tasks.create(testCompileTaskName, PlatformScalaCompile.class, scalaCompile -> {
                scalaCompile.setDescription("Compiles the scala and java test sources for the " + binary.getDisplayName() + ".");
                scalaCompile.setClasspath(testCompileClasspath);
                scalaCompile.dependsOn(binary.getBuildTask());
                scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                scalaCompile.getDestinationDirectory().set(testClassesDir);
                scalaCompile.setSource((Object)testSources);
                String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                scalaCompile.setSourceCompatibility(targetCompatibility);
                scalaCompile.setTargetCompatibility(targetCompatibility);
                IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                incrementalOptions.getAnalysisFile().set(new File(buildDir, "tmp/scala/compilerAnalysis/" + testCompileTaskName + ".analysis"));
            });
            String testTaskName = binary.getTasks().taskName("test");
            File binaryBuildDir = new File(buildDir, binary.getProjectScopedName());
            FileCollection testClassesDirs = projectLayout.files(testClassesDir);
            tasks.create(testTaskName, Test.class, test -> {
                test.setDescription("Runs " + WordUtils.uncapitalize((String)(binary.getDisplayName() + ".")));
                test.setClasspath(testClassesDirs.plus(testCompileClasspath));
                test.setTestClassesDirs(testClassesDirs);
                test.setBinResultsDir(new File(binaryBuildDir, "results/" + testTaskName + "/bin"));
                test.getReports().getJunitXml().setDestination(new File(binaryBuildDir, "reports/test/xml"));
                test.getReports().getHtml().setDestination(new File(binaryBuildDir, "reports/test"));
                test.dependsOn(testCompileTaskName);
                test.setWorkingDir(projectIdentifier.getProjectDir());
            });
            binary.getTasks().add(tasks.get(testTaskName));
        }
    }

    @Mutate
    void attachTestSuitesToCheckTask(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<PlayApplicationBinarySpec> playBinaries) {
        tasks.named("check", checkTask -> {
            for (PlayApplicationBinarySpec binary : playBinaries) {
                checkTask.dependsOn(binary.getTasks().withType(Test.class));
            }
        });
    }
}

