/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.Main;
import org.codehaus.groovy.util.ReleaseInfo;
import org.gradle.api.Action;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.initialization.ParallelismConfigurationCommandLineConverter;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.LoggingCommandLineConverter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.bootstrap.CommandLineActionFactory;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.BuildActionsFactory;
import org.gradle.launcher.cli.CommandLineAction;
import org.gradle.launcher.cli.DebugLoggerWarningAction;
import org.gradle.launcher.cli.ExceptionReportingAction;
import org.gradle.launcher.cli.KotlinDslVersion;
import org.gradle.launcher.cli.NativeServicesInitializingAction;
import org.gradle.launcher.cli.WelcomeMessageAction;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.PropertiesToLogLevelConfigurationConverter;
import org.gradle.launcher.cli.converter.PropertiesToParallelismConfigurationConverter;
import org.gradle.util.GradleVersion;

public class DefaultCommandLineActionFactory
implements CommandLineActionFactory {
    public static final String WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY = "org.gradle.internal.launcher.welcomeMessageEnabled";
    private static final String HELP = "h";
    private static final String VERSION = "v";

    @Override
    public CommandLineActionFactory.CommandLineExecution convert(List<String> args) {
        ServiceRegistry loggingServices = this.createLoggingServices();
        DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
        return new WithLogging(loggingServices, args, loggingConfiguration, new ParseAndBuildAction(loggingServices, args), new BuildExceptionReporter(loggingServices.get(StyledTextOutputFactory.class), loggingConfiguration, DefaultCommandLineActionFactory.clientMetaData()));
    }

    @VisibleForTesting
    protected void createActionFactories(ServiceRegistry loggingServices, Collection<CommandLineAction> actions) {
        actions.add(new BuildActionsFactory(loggingServices));
    }

    private static GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }

    public ServiceRegistry createLoggingServices() {
        return LoggingServiceRegistry.newCommandLineProcessLogging();
    }

    private static void showUsage(PrintStream out, CommandLineParser parser) {
        out.println();
        out.print("USAGE: ");
        DefaultCommandLineActionFactory.clientMetaData().describeCommand(out, "[option...]", "[task...]");
        out.println();
        out.println();
        parser.printUsage(out);
        out.println();
    }

    private class ParseAndBuildAction
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final List<String> args;

        private ParseAndBuildAction(ServiceRegistry loggingServices, List<String> args) {
            this.loggingServices = loggingServices;
            this.args = args;
        }

        @Override
        public void execute(ExecutionListener executionListener) {
            Action<ExecutionListener> action;
            ArrayList<CommandLineAction> actions = new ArrayList<CommandLineAction>();
            actions.add(new BuiltInActions());
            DefaultCommandLineActionFactory.this.createActionFactories(this.loggingServices, actions);
            CommandLineParser parser = new CommandLineParser();
            for (CommandLineAction action2 : actions) {
                action2.configureCommandLineParser(parser);
            }
            try {
                ParsedCommandLine commandLine = parser.parse(this.args);
                action = this.createAction(actions, parser, commandLine);
            }
            catch (CommandLineArgumentException e) {
                action = new CommandLineParseFailureAction(parser, e);
            }
            action.execute(executionListener);
        }

        private Action<? super ExecutionListener> createAction(Iterable<CommandLineAction> factories, CommandLineParser parser, ParsedCommandLine commandLine) {
            for (CommandLineAction factory : factories) {
                Runnable action = factory.createAction(parser, commandLine);
                if (action == null) continue;
                return Actions.toAction(action);
            }
            throw new UnsupportedOperationException("No action factory for specified command-line arguments.");
        }
    }

    private static class WithLogging
    implements CommandLineActionFactory.CommandLineExecution {
        private final ServiceRegistry loggingServices;
        private final List<String> args;
        private final LoggingConfiguration loggingConfiguration;
        private final Action<ExecutionListener> action;
        private final Action<Throwable> reporter;

        WithLogging(ServiceRegistry loggingServices, List<String> args, LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action, Action<Throwable> reporter) {
            this.loggingServices = loggingServices;
            this.args = args;
            this.loggingConfiguration = loggingConfiguration;
            this.action = action;
            this.reporter = reporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(ExecutionListener executionListener) {
            LoggingCommandLineConverter loggingConfigurationConverter = new LoggingCommandLineConverter();
            LayoutCommandLineConverter buildLayoutConverter = new LayoutCommandLineConverter();
            ParallelismConfigurationCommandLineConverter parallelConverter = new ParallelismConfigurationCommandLineConverter();
            SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
            LayoutToPropertiesConverter layoutToPropertiesConverter = new LayoutToPropertiesConverter(new BuildLayoutFactory());
            BuildLayoutParameters buildLayout = new BuildLayoutParameters();
            DefaultParallelismConfiguration parallelismConfiguration = new DefaultParallelismConfiguration();
            CommandLineParser parser = new CommandLineParser();
            loggingConfigurationConverter.configure(parser);
            buildLayoutConverter.configure(parser);
            parallelConverter.configure(parser);
            systemPropertiesCommandLineConverter.configure(parser);
            parser.allowUnknownOptions();
            parser.allowMixedSubcommandsAndOptions();
            try {
                ParsedCommandLine parsedCommandLine = parser.parse(this.args);
                buildLayoutConverter.convert(parsedCommandLine, buildLayout);
                HashMap<String, String> properties = new HashMap<String, String>();
                layoutToPropertiesConverter.convert(buildLayout, properties);
                systemPropertiesCommandLineConverter.convert(parsedCommandLine, properties);
                PropertiesToLogLevelConfigurationConverter propertiesToLogLevelConfigurationConverter = new PropertiesToLogLevelConfigurationConverter();
                propertiesToLogLevelConfigurationConverter.convert(properties, this.loggingConfiguration);
                loggingConfigurationConverter.convert(parsedCommandLine, this.loggingConfiguration);
                PropertiesToParallelismConfigurationConverter propertiesToParallelismConfigurationConverter = new PropertiesToParallelismConfigurationConverter();
                propertiesToParallelismConfigurationConverter.convert(properties, parallelismConfiguration);
                parallelConverter.convert(parsedCommandLine, parallelismConfiguration);
            }
            catch (CommandLineArgumentException parsedCommandLine) {
                // empty catch block
            }
            LoggingManagerInternal loggingManager = this.loggingServices.getFactory(LoggingManagerInternal.class).create();
            loggingManager.setLevelInternal(this.loggingConfiguration.getLogLevel());
            loggingManager.start();
            ExceptionReportingAction exceptionReportingAction = new ExceptionReportingAction(this.reporter, loggingManager, new NativeServicesInitializingAction(buildLayout, this.loggingConfiguration, loggingManager, new WelcomeMessageAction(buildLayout, new DebugLoggerWarningAction(this.loggingConfiguration, this.action))));
            try {
                exceptionReportingAction.execute(executionListener);
            }
            finally {
                loggingManager.stop();
            }
        }
    }

    private static class ShowVersionAction
    implements Runnable {
        private ShowVersionAction() {
        }

        @Override
        public void run() {
            GradleVersion currentVersion = GradleVersion.current();
            StringBuilder sb = new StringBuilder();
            sb.append("%n------------------------------------------------------------%nGradle ");
            sb.append(currentVersion.getVersion());
            sb.append("%n------------------------------------------------------------%n%nBuild time:   ");
            sb.append(currentVersion.getBuildTime());
            sb.append("%nRevision:     ");
            sb.append(currentVersion.getRevision());
            sb.append("%n%nKotlin:       ");
            sb.append(KotlinDslVersion.current().getKotlinVersion());
            sb.append("%nGroovy:       ");
            sb.append(ReleaseInfo.getVersion());
            sb.append("%nAnt:          ");
            sb.append(Main.getAntVersion());
            sb.append("%nJVM:          ");
            sb.append(Jvm.current());
            sb.append("%nOS:           ");
            sb.append(OperatingSystem.current());
            sb.append("%n");
            System.out.println(String.format(sb.toString(), new Object[0]));
        }
    }

    private static class ShowUsageAction
    implements Runnable {
        private final CommandLineParser parser;

        public ShowUsageAction(CommandLineParser parser) {
            this.parser = parser;
        }

        @Override
        public void run() {
            DefaultCommandLineActionFactory.showUsage(System.out, this.parser);
        }
    }

    private static class CommandLineParseFailureAction
    implements Action<ExecutionListener> {
        private final Exception exception;
        private final CommandLineParser parser;

        public CommandLineParseFailureAction(CommandLineParser parser, Exception exception) {
            this.parser = parser;
            this.exception = exception;
        }

        @Override
        public void execute(ExecutionListener executionListener) {
            System.err.println();
            System.err.println(this.exception.getMessage());
            DefaultCommandLineActionFactory.showUsage(System.err, this.parser);
            executionListener.onFailure(this.exception);
        }
    }

    private static class BuiltInActions
    implements CommandLineAction {
        private BuiltInActions() {
        }

        @Override
        public void configureCommandLineParser(CommandLineParser parser) {
            parser.option(DefaultCommandLineActionFactory.HELP, "?", "help").hasDescription("Shows this help message.");
            parser.option(DefaultCommandLineActionFactory.VERSION, "version").hasDescription("Print version info.");
        }

        @Override
        public Runnable createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
            if (commandLine.hasOption(DefaultCommandLineActionFactory.HELP)) {
                return new ShowUsageAction(parser);
            }
            if (commandLine.hasOption(DefaultCommandLineActionFactory.VERSION)) {
                return new ShowVersionAction();
            }
            return null;
        }
    }
}

