/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarFile;
import org.gradle.jvm.internal.DefaultJvmBinarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JarFile;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.tasks.Jar;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryTasksCollectionWrapper;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;

public class DefaultJarBinarySpec
extends DefaultJvmBinarySpec
implements JarBinarySpecInternal {
    private final JarFile apiJar;
    private final JarFile jarFile;
    private Set<String> exportedPackages = ImmutableSet.of();
    private Set<DependencySpec> apiDependencies = ImmutableSet.of();
    private Set<DependencySpec> componentLevelDependencies = ImmutableSet.of();
    private final DefaultTasksCollection tasks = new DefaultTasksCollection(super.getTasks());

    public DefaultJarBinarySpec() {
        this.apiJar = this.childJarFile("apiJarFile");
        this.jarFile = this.childJarFile("jarFile");
    }

    private DefaultJarFile childJarFile(String childName) {
        return new DefaultJarFile(this.getIdentifier().child(childName));
    }

    @Override
    public JarBinarySpec.TasksCollection getTasks() {
        return this.tasks;
    }

    @Override
    public JvmLibrarySpec getLibrary() {
        return this.getComponentAs(JvmLibrarySpec.class);
    }

    @Override
    protected String getTypeName() {
        return "Jar";
    }

    @Override
    public JarFile getApiJar() {
        return this.apiJar;
    }

    @Override
    public JarFile getRuntimeJar() {
        return this.jarFile;
    }

    @Override
    public File getJarFile() {
        return this.jarFile.getFile();
    }

    @Override
    public void setJarFile(File jarFile) {
        this.jarFile.setFile(jarFile);
    }

    @Override
    public File getApiJarFile() {
        return this.apiJar.getFile();
    }

    @Override
    public void setApiJarFile(File apiJarFile) {
        this.apiJar.setFile(apiJarFile);
    }

    @Override
    public void setExportedPackages(Set<String> exportedPackages) {
        this.exportedPackages = ImmutableSet.copyOf(exportedPackages);
    }

    @Override
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    @Override
    public void setApiDependencies(Collection<DependencySpec> apiDependencies) {
        this.apiDependencies = ImmutableSet.copyOf(apiDependencies);
    }

    @Override
    public Collection<DependencySpec> getApiDependencies() {
        return this.apiDependencies;
    }

    @Override
    public void setDependencies(Collection<DependencySpec> dependencies) {
        this.componentLevelDependencies = ImmutableSet.copyOf(dependencies);
    }

    @Override
    public Collection<DependencySpec> getDependencies() {
        return this.componentLevelDependencies;
    }

    @Override
    protected BinaryBuildAbility getBinaryBuildAbility() {
        return new ToolSearchBuildAbility(((JavaToolChainInternal)this.getToolChain()).select(this.getTargetPlatform()));
    }

    static class DefaultTasksCollection
    extends BinaryTasksCollectionWrapper
    implements JarBinarySpec.TasksCollection {
        public DefaultTasksCollection(BinaryTasksCollection delegate) {
            super(delegate);
        }

        @Override
        public Jar getJar() {
            return this.findSingleTaskWithType(Jar.class);
        }
    }
}

