/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseExceptionNoStackTrace;

@Contextual
public class ModuleVersionResolveException
extends DefaultMultiCauseExceptionNoStackTrace {
    private final List<List<? extends ComponentIdentifier>> paths = new ArrayList<List<? extends ComponentIdentifier>>();
    private final ComponentSelector selector;

    public ModuleVersionResolveException(ComponentSelector selector, Factory<String> message, Throwable cause) {
        super(message, cause);
        this.selector = selector;
    }

    public ModuleVersionResolveException(ComponentSelector selector, Factory<String> message) {
        super(message);
        this.selector = selector;
    }

    public ModuleVersionResolveException(ComponentSelector selector, Throwable cause) {
        this(selector, ModuleVersionResolveException.format("Could not resolve %s.", selector));
        this.initCause(cause);
    }

    public ModuleVersionResolveException(ComponentSelector selector, Iterable<? extends Throwable> causes) {
        this(selector, ModuleVersionResolveException.format("Could not resolve %s.", selector));
        this.initCauses(causes);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Factory<String> message) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector), message);
    }

    public ModuleVersionResolveException(ModuleVersionIdentifier id, Factory<String> message) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(id.getModule(), DefaultImmutableVersionConstraint.of(id.getVersion())), message);
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, Factory<String> messageFormat) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(id.getGroup(), id.getModule()), DefaultImmutableVersionConstraint.of(id.getVersion())), messageFormat);
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, Throwable cause) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(id.getGroup(), id.getModule()), DefaultImmutableVersionConstraint.of(id.getVersion())), Collections.singletonList(cause));
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, Iterable<? extends Throwable> causes) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(id.getGroup(), id.getModule()), DefaultImmutableVersionConstraint.of(id.getVersion())), causes);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Throwable cause) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector), cause);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Iterable<? extends Throwable> causes) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector), causes);
    }

    public ComponentSelector getSelector() {
        return this.selector;
    }

    protected static Factory<String> format(String messageFormat, ComponentSelector selector) {
        return () -> String.format(messageFormat, selector.getDisplayName());
    }

    public ModuleVersionResolveException withIncomingPaths(Collection<? extends List<? extends ComponentIdentifier>> paths) {
        ModuleVersionResolveException copy = this.createCopy();
        copy.paths.addAll(paths);
        copy.initCauses(this.getCauses());
        copy.setStackTrace(this.getStackTrace());
        return copy;
    }

    @Override
    public String getMessage() {
        if (this.paths.isEmpty()) {
            return super.getMessage();
        }
        Formatter formatter = new Formatter();
        formatter.format("%s%nRequired by:", super.getMessage());
        for (List<? extends ComponentIdentifier> path : this.paths) {
            formatter.format("%n    %s", this.toString(path.get(0)));
            for (int i = 1; i < path.size(); ++i) {
                formatter.format(" > %s", this.toString(path.get(i)));
            }
        }
        return formatter.toString();
    }

    private String toString(ComponentIdentifier identifier) {
        return identifier.getDisplayName();
    }

    protected ModuleVersionResolveException createCopy() {
        try {
            String message = this.getMessage();
            return (ModuleVersionResolveException)this.getClass().getConstructor(ComponentSelector.class, Factory.class).newInstance(this.selector, () -> message);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

