/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.jetbrains.annotations.NotNull;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;

public class DefaultPropertyAnnotationMetadata
implements PropertyAnnotationMetadata {
    private final String propertyName;
    private final Method method;
    private final ImmutableMap<AnnotationCategory, Annotation> annotations;
    private final ImmutableSet<Class<? extends Annotation>> annotationTypes;

    public DefaultPropertyAnnotationMetadata(String propertyName, Method method, ImmutableMap<AnnotationCategory, Annotation> annotations) {
        this.propertyName = propertyName;
        this.method = method;
        this.annotations = annotations;
        this.annotationTypes = DefaultPropertyAnnotationMetadata.collectAnnotationTypes(annotations);
    }

    private static ImmutableSet<Class<? extends Annotation>> collectAnnotationTypes(ImmutableMap<AnnotationCategory, Annotation> annotations) {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)annotations.size());
        for (Annotation value : annotations.values()) {
            builder.add(value.annotationType());
        }
        return builder.build();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationTypes.contains(annotationType);
    }

    @Override
    public ImmutableMap<AnnotationCategory, Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public int compareTo(@NotNull PropertyAnnotationMetadata o) {
        return this.method.getName().compareTo(o.getMethod().getName());
    }

    public String toString() {
        return String.format("%s / %s()", this.propertyName, this.method.getName());
    }
}

