/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.GenericFileTreeSnapshotter;
import org.gradle.internal.fingerprint.impl.PatternSetSnapshottingFilter;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final VirtualFileSystem virtualFileSystem;
    private final GenericFileTreeSnapshotter genericFileTreeSnapshotter;
    private final Stat stat;

    public DefaultFileCollectionSnapshotter(VirtualFileSystem virtualFileSystem, GenericFileTreeSnapshotter genericFileTreeSnapshotter, Stat stat) {
        this.virtualFileSystem = virtualFileSystem;
        this.genericFileTreeSnapshotter = genericFileTreeSnapshotter;
        this.stat = stat;
    }

    @Override
    public List<FileSystemSnapshot> snapshot(FileCollection fileCollection) {
        SnapshottingVisitor visitor = new SnapshottingVisitor();
        ((FileCollectionInternal)fileCollection).visitStructure(visitor);
        return visitor.getRoots();
    }

    private class SnapshottingVisitor
    implements FileCollectionStructureVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();

        private SnapshottingVisitor() {
        }

        @Override
        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            for (File file : contents) {
                DefaultFileCollectionSnapshotter.this.virtualFileSystem.read(file.getAbsolutePath(), this.roots::add);
            }
        }

        @Override
        public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.roots.add(DefaultFileCollectionSnapshotter.this.genericFileTreeSnapshotter.snapshotFileTree(fileTree));
        }

        @Override
        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            DefaultFileCollectionSnapshotter.this.virtualFileSystem.read(root.getAbsolutePath(), new PatternSetSnapshottingFilter(patterns, DefaultFileCollectionSnapshotter.this.stat), snapshot -> {
                if (snapshot.getType() != FileType.Missing) {
                    this.roots.add((FileSystemSnapshot)snapshot);
                }
            });
        }

        @Override
        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            DefaultFileCollectionSnapshotter.this.virtualFileSystem.read(file.getAbsolutePath(), this.roots::add);
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

