/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.initialization.IGradlePropertiesLoader;

public class DefaultGradlePropertiesController
implements GradlePropertiesController {
    private State state = new NotLoaded();
    private final GradleProperties sharedGradleProperties = new SharedGradleProperties();
    private final IGradlePropertiesLoader propertiesLoader;

    public DefaultGradlePropertiesController(IGradlePropertiesLoader propertiesLoader) {
        this.propertiesLoader = propertiesLoader;
    }

    @Override
    public GradleProperties getGradleProperties() {
        return this.sharedGradleProperties;
    }

    @Override
    public void loadGradlePropertiesFrom(File settingsDir) {
        this.state = this.state.loadGradlePropertiesFrom(settingsDir);
    }

    private static class Loaded
    implements State {
        private final GradleProperties gradleProperties;
        private final File propertiesDir;

        public Loaded(GradleProperties gradleProperties, File propertiesDir) {
            this.gradleProperties = gradleProperties;
            this.propertiesDir = propertiesDir;
        }

        @Override
        public GradleProperties gradleProperties() {
            return this.gradleProperties;
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir) {
            if (!this.propertiesDir.equals(settingsDir)) {
                throw new IllegalStateException(String.format("GradleProperties has already been loaded from '%s' and cannot be loaded from '%s'.", this.propertiesDir, settingsDir));
            }
            return this;
        }
    }

    private class NotLoaded
    implements State {
        private NotLoaded() {
        }

        @Override
        public GradleProperties gradleProperties() {
            throw new IllegalStateException("GradleProperties has not been loaded yet.");
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir) {
            return new Loaded(DefaultGradlePropertiesController.this.propertiesLoader.loadGradleProperties(settingsDir), settingsDir);
        }
    }

    private static interface State {
        public GradleProperties gradleProperties();

        public State loadGradlePropertiesFrom(File var1);
    }

    private class SharedGradleProperties
    implements GradleProperties {
        private SharedGradleProperties() {
        }

        @Override
        @Nullable
        public String find(String propertyName) {
            return this.gradleProperties().find(propertyName);
        }

        @Override
        public Map<String, String> mergeProperties(Map<String, String> properties) {
            return this.gradleProperties().mergeProperties(properties);
        }

        private GradleProperties gradleProperties() {
            return DefaultGradlePropertiesController.this.state.gradleProperties();
        }
    }
}

