/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.versionmapping;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.DefaultVariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;

public class DefaultVersionMappingStrategy
implements VersionMappingStrategyInternal {
    private final ObjectFactory objectFactory;
    private final ConfigurationContainer configurations;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final List<Action<? super VariantVersionMappingStrategy>> mappingsForAllVariants = Lists.newArrayListWithExpectedSize((int)2);
    private final Map<ImmutableAttributes, String> defaultConfigurations = Maps.newHashMap();
    private final Multimap<ImmutableAttributes, Action<? super VariantVersionMappingStrategy>> attributeBasedMappings = ArrayListMultimap.create();

    @Inject
    public DefaultVersionMappingStrategy(ObjectFactory objectFactory, ConfigurationContainer configurations, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory) {
        this.objectFactory = objectFactory;
        this.configurations = configurations;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public void allVariants(Action<? super VariantVersionMappingStrategy> action) {
        this.mappingsForAllVariants.add(action);
    }

    @Override
    public <T> void variant(Attribute<T> attribute, T attributeValue, Action<? super VariantVersionMappingStrategy> action) {
        this.attributeBasedMappings.put((Object)this.attributesFactory.of(attribute, attributeValue), action);
    }

    @Override
    public void usage(String usage, Action<? super VariantVersionMappingStrategy> action) {
        this.variant(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, usage), action);
    }

    @Override
    public void defaultResolutionConfiguration(String usage, String defaultConfiguration) {
        this.defaultConfigurations.put(this.attributesFactory.of(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, usage)), defaultConfiguration);
    }

    @Override
    public VariantVersionMappingStrategyInternal findStrategyForVariant(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = this.createDefaultMappingStrategy(variantAttributes);
        for (Action<? super VariantVersionMappingStrategy> action : this.mappingsForAllVariants) {
            action.execute(strategy);
        }
        if (!this.attributeBasedMappings.isEmpty()) {
            Set candidates;
            AttributeMatcher matcher = this.schema.matcher();
            List matches = matcher.matches(candidates = this.attributeBasedMappings.keySet(), variantAttributes, AttributeMatchingExplanationBuilder.NO_OP);
            if (matches.size() == 1) {
                Collection actions = this.attributeBasedMappings.get((Object)((ImmutableAttributes)matches.get(0)));
                for (Action action : actions) {
                    action.execute(strategy);
                }
            } else if (matches.size() > 1) {
                throw new InvalidUserCodeException("Unable to find a suitable version mapping strategy for " + variantAttributes);
            }
        }
        return strategy;
    }

    private DefaultVariantVersionMappingStrategy createDefaultMappingStrategy(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = new DefaultVariantVersionMappingStrategy(this.configurations);
        if (!this.defaultConfigurations.isEmpty()) {
            AttributeMatcher matcher = this.schema.matcher();
            Set<ImmutableAttributes> candidates = this.defaultConfigurations.keySet();
            List<ImmutableAttributes> matches = matcher.matches(candidates, variantAttributes, AttributeMatchingExplanationBuilder.NO_OP);
            for (ImmutableAttributes match : matches) {
                strategy.setTargetConfiguration(this.configurations.getByName(this.defaultConfigurations.get(match)));
            }
        }
        return strategy;
    }
}

