/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassChanges;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class ClasspathChangeDependentsFinder {
    private final ClasspathSnapshot classpathSnapshot;
    private final PreviousCompilation previousCompilation;

    public ClasspathChangeDependentsFinder(ClasspathSnapshot classpathSnapshot, PreviousCompilation previousCompilation) {
        this.classpathSnapshot = classpathSnapshot;
        this.previousCompilation = previousCompilation;
    }

    public DependentsSet getActualDependents(InputFileDetails entryChangeDetails, File classpathEntry) {
        if (entryChangeDetails.isAdded()) {
            return this.handleAdded(classpathEntry);
        }
        ClasspathEntrySnapshot previous = this.previousCompilation.getClasspathEntrySnapshot(entryChangeDetails.getFile());
        if (previous == null) {
            return DependentsSet.dependencyToAll("missing classpath entry snapshot of '" + classpathEntry + "' from previous build");
        }
        if (entryChangeDetails.isRemoved()) {
            return this.handleRemoved(previous);
        }
        if (entryChangeDetails.isModified()) {
            return this.handleModified(classpathEntry, previous);
        }
        throw new IllegalArgumentException("Unknown input file details provided: " + entryChangeDetails);
    }

    private DependentsSet handleAdded(File classpathEntry) {
        if (this.classpathSnapshot.isAnyClassDuplicated(classpathEntry)) {
            return DependentsSet.dependencyToAll("at least one of the classes of '" + classpathEntry + "' is already present in classpath");
        }
        return DependentsSet.empty();
    }

    private DependentsSet handleRemoved(ClasspathEntrySnapshot previous) {
        DependentsSet allClasses = previous.getAllClasses();
        if (allClasses.isDependencyToAll()) {
            return allClasses;
        }
        DependentsSet affectedOnClasspath = this.collectDependentsFromClasspath(allClasses.getAllDependentClasses());
        if (affectedOnClasspath.isDependencyToAll()) {
            return affectedOnClasspath;
        }
        return this.previousCompilation.getDependents(affectedOnClasspath.getAllDependentClasses(), previous.getAllConstants(affectedOnClasspath));
    }

    private DependentsSet handleModified(File classpathEntry, ClasspathEntrySnapshot previous) {
        ClasspathEntrySnapshot currentSnapshot = this.classpathSnapshot.getSnapshot(classpathEntry);
        ClassChanges classChanges = currentSnapshot.getChangedClassesSince(previous);
        if (this.classpathSnapshot.isAnyClassDuplicated(classChanges.getAdded())) {
            return DependentsSet.dependencyToAll("at least one of the classes of modified classpath entry '" + classpathEntry + "' is already present in the classpath");
        }
        DependentsSet affectedOnClasspath = this.collectDependentsFromClasspath((Set<String>)Sets.union(classChanges.getModified(), classChanges.getAdded()));
        if (affectedOnClasspath.isDependencyToAll()) {
            return affectedOnClasspath;
        }
        Set<String> joined = affectedOnClasspath.getAllDependentClasses();
        return this.previousCompilation.getDependents(joined, currentSnapshot.getRelevantConstants(previous, joined));
    }

    private DependentsSet collectDependentsFromClasspath(Set<String> modified) {
        HashSet privateDependentClasses = Sets.newHashSet(modified);
        HashSet accessibleDependentClasses = Sets.newHashSet(modified);
        LinkedList queue = Lists.newLinkedList(modified);
        while (!queue.isEmpty()) {
            String dependentClass = (String)queue.poll();
            for (File entry : this.classpathSnapshot.getEntries()) {
                DependentsSet dependents = this.collectDependentsFromClasspathEntry(dependentClass, entry);
                if (dependents.isDependencyToAll()) {
                    return dependents;
                }
                for (String intermediate : dependents.getPrivateDependentClasses()) {
                    if (!privateDependentClasses.add(intermediate) || accessibleDependentClasses.contains(intermediate)) continue;
                    queue.add(intermediate);
                }
                for (String intermediate : dependents.getAccessibleDependentClasses()) {
                    if (!accessibleDependentClasses.add(intermediate) || privateDependentClasses.contains(intermediate)) continue;
                    queue.add(intermediate);
                }
            }
        }
        return DependentsSet.dependentClasses(privateDependentClasses, accessibleDependentClasses);
    }

    private DependentsSet collectDependentsFromClasspathEntry(String dependentClass, File entry) {
        ClasspathEntrySnapshot entrySnapshot = this.classpathSnapshot.getSnapshot(entry);
        ClassSetAnalysisData data = entrySnapshot.getData().getClassAnalysis();
        return data.getDependents(dependentClass);
    }
}

