/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class ParallelResolveArtifactSet {
    private static final EmptySet EMPTY = new EmptySet();

    public abstract void visit(ArtifactVisitor var1);

    public static ParallelResolveArtifactSet wrap(ResolvedArtifactSet artifacts, BuildOperationExecutor buildOperationProcessor) {
        if (artifacts == ResolvedArtifactSet.EMPTY) {
            return EMPTY;
        }
        return new VisitingSet(artifacts, buildOperationProcessor);
    }

    private static class VisitingSet
    extends ParallelResolveArtifactSet {
        private final ResolvedArtifactSet artifacts;
        private final BuildOperationExecutor buildOperationProcessor;

        VisitingSet(ResolvedArtifactSet artifacts, BuildOperationExecutor buildOperationProcessor) {
            this.artifacts = artifacts;
            this.buildOperationProcessor = buildOperationProcessor;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            StartVisitAction visitAction = new StartVisitAction(visitor);
            this.buildOperationProcessor.runAll(visitAction);
            visitAction.result.visit(visitor);
        }

        private class StartVisitAction
        implements Action<BuildOperationQueue<RunnableBuildOperation>> {
            private final ArtifactVisitor visitor;
            ResolvedArtifactSet.Completion result;

            StartVisitAction(ArtifactVisitor visitor) {
                this.visitor = visitor;
            }

            @Override
            public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                this.result = VisitingSet.this.artifacts.startVisit(buildOperationQueue, new AsyncArtifactListenerAdapter(this.visitor));
            }
        }

        private static class AsyncArtifactListenerAdapter
        implements ResolvedArtifactSet.AsyncArtifactListener {
            private final ArtifactVisitor visitor;

            AsyncArtifactListenerAdapter(ArtifactVisitor visitor) {
                this.visitor = visitor;
            }

            @Override
            public void artifactAvailable(ResolvableArtifact artifact) {
            }

            @Override
            public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
                return this.visitor.prepareForVisit(source);
            }

            @Override
            public boolean requireArtifactFiles() {
                return this.visitor.requireArtifactFiles();
            }
        }
    }

    private static class EmptySet
    extends ParallelResolveArtifactSet {
        private EmptySet() {
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
        }
    }
}

