/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ArtifactId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;

public class IvyModuleDescriptorConverter {
    private static final IvyArtifactName WILDARD_ARTIFACT = new DefaultIvyArtifactName("*", "*", "*");
    private static final String CLASSIFIER = "classifier";
    private static final Field DEPENDENCY_CONFIG_FIELD;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IvyModuleDescriptorConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public Map<NamespaceId, String> extractExtraAttributes(ModuleDescriptor ivyDescriptor) {
        return (Map)Cast.uncheckedCast(ivyDescriptor.getExtraInfo());
    }

    public List<Exclude> extractExcludes(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getAllExcludeRules().length);
        for (ExcludeRule excludeRule : ivyDescriptor.getAllExcludeRules()) {
            result.add(this.forIvyExclude(excludeRule));
        }
        return result;
    }

    public List<IvyDependencyDescriptor> extractDependencies(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getDependencies().length);
        for (DependencyDescriptor dependencyDescriptor : ivyDescriptor.getDependencies()) {
            this.addDependency(result, dependencyDescriptor);
        }
        return result;
    }

    public List<org.gradle.internal.component.external.descriptor.Configuration> extractConfigurations(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getConfigurations().length);
        for (Configuration ivyConfiguration : ivyDescriptor.getConfigurations()) {
            IvyModuleDescriptorConverter.addConfiguration(result, ivyConfiguration);
        }
        return result;
    }

    private static void addConfiguration(List<org.gradle.internal.component.external.descriptor.Configuration> result, Configuration configuration) {
        String name = configuration.getName();
        boolean transitive = configuration.isTransitive();
        boolean visible = configuration.getVisibility() == Configuration.Visibility.PUBLIC;
        ArrayList extendsFrom = Lists.newArrayList((Object[])configuration.getExtends());
        result.add(new org.gradle.internal.component.external.descriptor.Configuration(name, transitive, visible, extendsFrom));
    }

    private void addDependency(List<IvyDependencyDescriptor> result, DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId revisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleComponentSelector requested = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(revisionId.getOrganisation(), revisionId.getName()), new DefaultImmutableVersionConstraint(revisionId.getRevision()));
        ArrayListMultimap configMappings = ArrayListMultimap.create();
        for (Map.Entry<String, List<String>> entry : IvyModuleDescriptorConverter.readConfigMappings(dependencyDescriptor).entrySet()) {
            configMappings.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        ArrayList artifacts = Lists.newArrayList();
        for (DependencyArtifactDescriptor ivyArtifact : dependencyDescriptor.getAllDependencyArtifacts()) {
            DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(ivyArtifact.getName(), ivyArtifact.getType(), ivyArtifact.getExt(), (String)ivyArtifact.getExtraAttributes().get(CLASSIFIER));
            artifacts.add(new Artifact(ivyArtifactName, Sets.newHashSet((Object[])ivyArtifact.getConfigurations())));
        }
        ArrayList arrayList = Lists.newArrayList();
        for (ExcludeRule excludeRule : dependencyDescriptor.getAllExcludeRules()) {
            arrayList.add(this.forIvyExclude(excludeRule));
        }
        result.add(new IvyDependencyDescriptor(requested, dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive(), false, (Multimap<String, String>)configMappings, artifacts, arrayList));
    }

    private Exclude forIvyExclude(ExcludeRule excludeRule) {
        ArtifactId id = excludeRule.getId();
        IvyArtifactName artifactExclusion = this.artifactForIvyExclude(id);
        return new DefaultExclude(this.moduleIdentifierFactory.module(id.getModuleId().getOrganisation(), id.getModuleId().getName()), artifactExclusion, excludeRule.getConfigurations(), excludeRule.getMatcher().getName());
    }

    private IvyArtifactName artifactForIvyExclude(ArtifactId id) {
        if ("*".equals(id.getName()) && "*".equals(id.getType()) && "*".equals(id.getExt())) {
            return null;
        }
        return new DefaultIvyArtifactName(id.getName(), id.getType(), id.getExt());
    }

    private static Map<String, List<String>> readConfigMappings(DependencyDescriptor dependencyDescriptor) {
        if (dependencyDescriptor instanceof DefaultDependencyDescriptor) {
            try {
                return (Map)DEPENDENCY_CONFIG_FIELD.get(dependencyDescriptor);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        String[] modConfs = dependencyDescriptor.getModuleConfigurations();
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (String modConf : modConfs) {
            results.put(modConf, Arrays.asList(dependencyDescriptor.getDependencyConfigurations(modConfs)));
        }
        return results;
    }

    static {
        try {
            DEPENDENCY_CONFIG_FIELD = DefaultDependencyDescriptor.class.getDeclaredField("confs");
            DEPENDENCY_CONFIG_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

