/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ArtifactCollectionInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFileCollectionVisitor;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFilesCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.artifacts.transform.DefaultExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.FailureCollectingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.Path;
import org.gradle.util.WrapUtil;

public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator {
    private static final Action<Throwable> DEFAULT_ERROR_HANDLER = throwable -> {
        throw UncheckedException.throwAsUncheckedException(throwable);
    };
    private final ConfigurationResolver resolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final DomainObjectContext owner;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ProjectAccessListener projectAccessListener;
    private final ProjectFinder projectFinder;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final DocumentationRegistry documentationRegistry;
    private final Set<MutationValidator> childMutationValidators = Sets.newHashSet();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path path;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private final ProjectStateRegistry.SafeExclusiveLock resolutionLock;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private volatile ConfigurationInternal.InternalState resolvedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private ResolverResults cachedResolverResults;
    private boolean dependenciesModified;
    private boolean canBeConsumed = true;
    private boolean canBeResolved = true;
    private boolean canBeMutated = true;
    private AttributeContainerInternal configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ImmutableAttributesFactory attributesFactory;
    private final ConfigurationFileCollection intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final AtomicInteger copyCount = new AtomicInteger(0);
    private Action<? super ConfigurationInternal> beforeLocking;
    private List<String> declarationAlternatives;
    private List<String> consumptionAlternatives;
    private List<String> resolutionAlternatives;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, ProjectAccessListener projectAccessListener, ProjectFinder projectFinder, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ImmutableAttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, DocumentationRegistry documentationRegistry, UserCodeApplicationContext userCodeApplicationContext, DomainObjectContext owner, ProjectStateRegistry projectStateRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.projectAccessListener = projectAccessListener;
        this.projectFinder = projectFinder;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        this.buildOperationExecutor = buildOperationExecutor;
        this.instantiator = instantiator;
        this.artifactNotationParser = artifactNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.attributesFactory = attributesFactory;
        this.configurationAttributes = attributesFactory.mutable();
        this.domainObjectContext = domainObjectContext;
        this.intrinsicFiles = new ConfigurationFileCollection(Specs.satisfyAll());
        this.documentationRegistry = documentationRegistry;
        this.resolutionLock = projectStateRegistry.newExclusiveOperationLock();
        this.resolvableDependencies = instantiator.newInstance(ConfigurationResolvableDependencies.class, this);
        this.displayName = Describables.memoize(new ConfigurationDescription(this.identityPath));
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet(Describables.of(this.displayName, "dependencies"), this, this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "dependency constraints"), this, this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet(Describables.of(this.displayName, "artifacts"), this.ownArtifacts, fileCollectionFactory);
        this.outgoing = instantiator.newInstance(DefaultConfigurationPublications.class, this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory);
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.owner = owner;
        this.path = domainObjectContext.projectPath(name);
    }

    private static Action<Void> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Configuration.State getState() {
        if (this.resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || this.resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (this.cachedResolverResults.hasError()) {
                return Configuration.State.RESOLVED_WITH_FAILURES;
            }
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    public ConfigurationInternal.InternalState getResolvedState() {
        return this.resolvedState;
    }

    @Override
    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection(configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection(configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection(configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection(configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection(configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection(configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set<Configuration> result = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result.remove(superConfig);
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    @Override
    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute((DependencySet)dependencies);
            }
        });
        return this;
    }

    @Override
    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.defaultDependencyActions.execute(this.dependencies);
        this.withDependencyActions.execute(this.dependencies);
        this.defaultDependencyActions = ImmutableActionSet.empty();
        this.withDependencyActions = ImmutableActionSet.empty();
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).runDependencyActions();
        }
    }

    @Override
    public Set<Configuration> getAll() {
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    @Override
    public Set<File> resolve() {
        return this.getFiles();
    }

    @Override
    public Iterator<File> iterator() {
        return this.intrinsicFiles.iterator();
    }

    @Override
    public Set<File> getFiles() {
        return this.intrinsicFiles.getFiles();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.intrinsicFiles.visitContents(visitor);
    }

    @Override
    public boolean contains(File file) {
        return this.intrinsicFiles.contains(file);
    }

    @Override
    public boolean isEmpty() {
        return this.intrinsicFiles.isEmpty();
    }

    @Override
    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    @Override
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    @Override
    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        return new ConfigurationFileCollection(dependencySpec);
    }

    @Override
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return new ConfigurationFileCollection(dependencySpecClosure);
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencies) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet(dependencies));
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        return this.cachedResolverResults.getResolvedConfiguration();
    }

    private void resolveToStateOrLater(ConfigurationInternal.InternalState requestedState) {
        this.assertIsResolvable();
        this.warnIfConfigurationIsDeprecatedForResolving();
        if (!this.owner.getModel().hasMutableState()) {
            if (!GradleThread.isManaged()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            DeprecationLogger.deprecateBehaviour("The configuration " + this.identityPath.toString() + " was resolved without accessing the project in a safe manner.  This may happen when a configuration is resolved from a different project.").willBeRemovedInGradle7().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors").nagUser();
            this.owner.getModel().withLenientState(() -> this.resolveExclusively(requestedState));
        } else {
            this.resolveExclusively(requestedState);
        }
    }

    private void warnIfConfigurationIsDeprecatedForResolving() {
        if (this.resolutionAlternatives != null) {
            ((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration(this.name).forResolution().replaceWith(this.resolutionAlternatives)).willBecomeAnErrorInGradle7().withUpgradeGuideSection(5, "dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations").nagUser();
        }
    }

    private void resolveExclusively(ConfigurationInternal.InternalState requestedState) {
        this.resolutionLock.withLock(() -> {
            if (requestedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                this.resolveGraphIfRequired(requestedState);
            }
            if (requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                this.resolveArtifactsIfRequired();
            }
        });
    }

    private void resolveGraphIfRequired(final ConfigurationInternal.InternalState requestedState) {
        if (this.resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || this.resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (this.dependenciesModified) {
                throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
            }
            return;
        }
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext context) {
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.preventFromFurtherMutation();
                ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)DefaultConfiguration.this.getIncoming();
                DefaultConfiguration.this.performPreResolveActions(incoming);
                DefaultResolverResults results = new DefaultResolverResults();
                DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this, results);
                DefaultConfiguration.this.dependenciesModified = false;
                DefaultConfiguration.this.cachedResolverResults = results;
                DefaultConfiguration.this.resolvedState = ConfigurationInternal.InternalState.GRAPH_RESOLVED;
                DefaultConfiguration.this.markParentsObserved(requestedState);
                DefaultConfiguration.this.markReferencedProjectConfigurationsObserved(requestedState);
                if (!DefaultConfiguration.this.cachedResolverResults.hasError()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve(incoming);
                    DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                }
                this.captureBuildOperationResult(context);
            }

            private void captureBuildOperationResult(BuildOperationContext context) {
                Throwable failure = DefaultConfiguration.this.cachedResolverResults.getFailure();
                if (failure != null) {
                    context.failed(failure);
                }
                ResolutionResult resolutionResult = DefaultConfiguration.this.cachedResolverResults.getResolutionResult();
                context.setResult(ResolveConfigurationResolutionBuildOperationResult.create(resolutionResult, DefaultConfiguration.this.attributesFactory));
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                Path projectPath = DefaultConfiguration.this.domainObjectContext.getProjectPath();
                String projectPathString = DefaultConfiguration.this.domainObjectContext.isScript() ? null : (projectPath == null ? null : projectPath.getPath());
                return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).details(new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getRepositories()));
            }
        });
    }

    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    private void markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState requestedState) {
        for (ResolvedProjectConfiguration projectResult : this.cachedResolverResults.getResolvedLocalComponents().getResolvedProjectConfigurations()) {
            ProjectInternal project = this.projectFinder.getProject(projectResult.getId().getProjectPath());
            ConfigurationInternal targetConfig = (ConfigurationInternal)project.getConfigurations().getByName(projectResult.getTargetConfiguration());
            targetConfig.markAsObserved(requestedState);
        }
    }

    private void resolveArtifactsIfRequired() {
        if (this.resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            return;
        }
        if (this.resolvedState != ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new IllegalStateException("Cannot resolve artifacts before graph has been resolved.");
        }
        this.resolver.resolveArtifacts(this, this.cachedResolverResults);
        this.resolvedState = ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED;
    }

    @Override
    public ExtraExecutionGraphDependenciesResolverFactory getDependenciesResolver() {
        return new DefaultExtraExecutionGraphDependenciesResolverFactory(this::getResultsForBuildDependencies, this::getResultsForArtifacts, new ResolveGraphAction(this), this.fileCollectionFactory);
    }

    private ResolverResults getResultsForBuildDependencies() {
        if (this.resolvedState == ConfigurationInternal.InternalState.UNRESOLVED) {
            throw new IllegalStateException("Cannot query results until resolution has happened.");
        }
        return this.cachedResolverResults;
    }

    private ResolverResults getResultsForArtifacts() {
        this.resolveExclusively(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        return this.cachedResolverResults;
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        if (this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
            this.resolveToStateOrLater(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.UNRESOLVED) {
            DefaultResolverResults results = new DefaultResolverResults();
            this.resolver.resolveBuildDependencies(this, results);
            this.resolvedState = ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED;
            this.cachedResolverResults = results;
        }
        return this.cachedResolverResults;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.assertIsResolvable();
        context.add(this.intrinsicFiles);
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this.getAllDependencies(), this.projectAccessListener);
        }
        return new TasksFromDependentProjects(taskName, this.getName());
    }

    @Override
    public DependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection(configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet(Describables.of(this.displayName, "all dependencies"), this, this.inheritedDependencies);
    }

    @Override
    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection(configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "all dependency constraints"), this, this.inheritedDependencyConstraints);
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of(this.displayName, "all artifacts");
        if (!this.canBeMutated && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory);
            return;
        }
        if (this.canBeMutated) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection(allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet(displayName, this.inheritedArtifacts, this.fileCollectionFactory) : new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory);
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser<Object, ExcludeRule> parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = Sets.newLinkedHashSet();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add(parser.parseNotation(excludeRule));
            }
        }
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.clear();
        this.excludeRules.addAll(excludeRules);
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Override
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    @Override
    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    @Override
    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public OutgoingVariant convertToOutgoingVariant() {
        return this.outgoing.convertToOutgoingVariant();
    }

    @Override
    public void beforeLocking(Action<? super ConfigurationInternal> action) {
        if (this.canBeMutated) {
            this.beforeLocking = this.beforeLocking != null ? Actions.composite(this.beforeLocking, action) : action;
        }
    }

    @Override
    public void preventFromFurtherMutation() {
        if (this.canBeMutated) {
            if (this.beforeLocking != null) {
                this.beforeLocking.execute(this);
                this.beforeLocking = null;
            }
            ImmutableAttributes delegatee = this.configurationAttributes.asImmutable();
            this.configurationAttributes = new ImmutableAttributeContainerWithErrorMessage(delegatee, this.displayName);
            this.outgoing.preventFromFurtherMutation();
            this.canBeMutated = false;
        }
    }

    @Override
    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute(this.outgoing);
    }

    @Override
    public ConfigurationInternal copy() {
        return this.createCopy(this.getDependencies(), this.getDependencyConstraints(), false);
    }

    @Override
    public Configuration copyRecursive() {
        return this.createCopy(this.getAllDependencies(), this.getAllDependencyConstraints(), true);
    }

    @Override
    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getDependencies(), dependencySpec), this.getDependencyConstraints(), false);
    }

    @Override
    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getAllDependencies(), dependencySpec), this.getAllDependencyConstraints(), true);
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints, boolean recursive) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(configurationsProvider);
        String newName = this.getNameWithCopySuffix();
        Factory<ResolutionStrategyInternal> childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant(this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultConfiguration copiedConfiguration = this.instantiator.newInstance(DefaultConfiguration.class, this.domainObjectContext, newName, configurationsProvider, this.resolver, this.listenerManager, this.metaDataProvider, childResolutionStrategy, this.projectAccessListener, this.projectFinder, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.documentationRegistry, this.userCodeApplicationContext, this.owner, this.projectStateRegistry, this.domainObjectCollectionFactory);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.canBeConsumed = this.canBeConsumed;
        copiedConfiguration.canBeResolved = this.canBeResolved;
        copiedConfiguration.getArtifacts().addAll(this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast(attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add(dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add(((DefaultDependencyConstraint)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    @Override
    public Configuration copy(Closure dependencySpec) {
        return this.copy(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public ComponentResolveMetadata toRootComponentMetaData() {
        return this.rootComponentMetadataBuilder.toRootComponentMetaData();
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure(closure, this.getResolutionStrategy());
        return this;
    }

    @Override
    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute(this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type == MutationValidator.MutationType.DEPENDENCIES) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if ((this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || this.observedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
    }

    private void markAsModified(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.dependenciesModified = true;
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    private void rethrowFailure(String type, Collection<Throwable> failures) {
        Throwable failure;
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() == 1 && (failure = failures.iterator().next()) instanceof ResolveException) {
            throw UncheckedException.throwAsUncheckedException(failure);
        }
        throw new DefaultLenientConfiguration.ArtifactResolveException(type, this.getIdentityPath().toString(), this.getDisplayName(), failures);
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    @Override
    public Configuration attributes(Action<? super AttributeContainer> action) {
        action.execute(this.configurationAttributes);
        return this;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public void setCanBeConsumed(boolean allowed) {
        this.validateMutation(MutationValidator.MutationType.ROLE);
        this.canBeConsumed = allowed;
    }

    @Override
    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    @Override
    public void setCanBeResolved(boolean allowed) {
        this.validateMutation(MutationValidator.MutationType.ROLE);
        this.canBeResolved = allowed;
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    @Override
    @Nullable
    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    @Override
    @Nullable
    public List<String> getConsumptionAlternatives() {
        return this.consumptionAlternatives;
    }

    @Override
    @Nullable
    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    @Override
    public boolean isFullyDeprecated() {
        return !(this.declarationAlternatives == null || this.canBeConsumed && this.consumptionAlternatives == null || this.canBeResolved && this.resolutionAlternatives == null);
    }

    @Override
    public DeprecatableConfiguration deprecateForDeclaration(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.copyOf((Object[])alternativesForDeclaring);
        return this;
    }

    @Override
    public DeprecatableConfiguration deprecateForConsumption(String ... alternativesForConsumption) {
        this.consumptionAlternatives = ImmutableList.copyOf((Object[])alternativesForConsumption);
        return this;
    }

    @Override
    public DeprecatableConfiguration deprecateForResolution(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.copyOf((Object[])alternativesForResolving);
        return this;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='").append(this.getClass()).append("'");
        reply.append("  name='").append(this.getName()).append("'");
        reply.append("  hashcode='").append(this.hashCode()).append("'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    public static class ResolveGraphAction
    implements WorkNodeAction {
        private final DefaultConfiguration configuration;

        public ResolveGraphAction(DefaultConfiguration configuration) {
            this.configuration = configuration;
        }

        public String toString() {
            return "resolve graph for " + this.configuration;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.configuration.owner.getProject();
        }

        @Override
        public void run(NodeExecutionContext context) {
            this.configuration.resolveExclusively(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    private class ConfigurationArtifactCollection
    implements ArtifactCollectionInternal {
        private final ConfigurationFileCollection fileCollection;
        private final boolean lenient;
        private Set<ResolvedArtifactResult> artifactResults;
        private Set<Throwable> failures;

        ConfigurationArtifactCollection() {
            this(defaultConfiguration.configurationAttributes, Specs.satisfyAll(), false, false);
        }

        ConfigurationArtifactCollection(AttributeContainerInternal attributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants) {
            DefaultConfiguration.this.assertIsResolvable();
            ImmutableAttributes viewAttributes = attributes.asImmutable();
            this.fileCollection = new ConfigurationFileCollection(Specs.satisfyAll(), viewAttributes, componentFilter, lenient, allowNoMatchingVariants);
            this.lenient = lenient;
        }

        @Override
        public FileCollection getArtifactFiles() {
            return this.fileCollection;
        }

        @Override
        public Set<ResolvedArtifactResult> getArtifacts() {
            this.ensureResolved();
            return this.artifactResults;
        }

        @Override
        public Iterator<ResolvedArtifactResult> iterator() {
            this.ensureResolved();
            return this.artifactResults.iterator();
        }

        @Override
        public Collection<Throwable> getFailures() {
            this.ensureResolved();
            return this.failures;
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor) {
            this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, this.lenient);
        }

        private synchronized void ensureResolved() {
            if (this.artifactResults != null) {
                return;
            }
            ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
            this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, this.lenient);
            this.artifactResults = visitor.getArtifacts();
            this.failures = visitor.getFailures();
            if (!this.lenient) {
                DefaultConfiguration.this.rethrowFailure("artifacts", this.failures);
            }
        }
    }

    public static class ArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final ImmutableAttributesFactory attributesFactory;
        private final AttributeContainerInternal configurationAttributes;
        private AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter;
        private boolean lenient;
        private boolean attributesUsed;

        public ArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal configurationAttributes) {
            this.attributesFactory = attributesFactory;
            this.configurationAttributes = configurationAttributes;
        }

        @Override
        public AttributeContainer getAttributes() {
            if (this.viewAttributes == null) {
                this.viewAttributes = this.attributesFactory.mutable(this.configurationAttributes);
                this.attributesUsed = true;
            }
            return this.viewAttributes;
        }

        @Override
        public ArtifactViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute(this.getAttributes());
            return this;
        }

        @Override
        public ArtifactViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            this.assertComponentFilterUnset();
            this.componentFilter = componentFilter;
            return this;
        }

        @Override
        public boolean isLenient() {
            return this.lenient;
        }

        @Override
        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        @Override
        public ArtifactViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        private void assertComponentFilterUnset() {
            if (this.componentFilter != null) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
        }

        private Spec<? super ComponentIdentifier> lockComponentFilter() {
            if (this.componentFilter == null) {
                this.componentFilter = Specs.satisfyAll();
            }
            return this.componentFilter;
        }

        private ImmutableAttributes lockViewAttributes() {
            this.viewAttributes = this.viewAttributes == null ? this.configurationAttributes.asImmutable() : this.viewAttributes.asImmutable();
            return this.viewAttributes.asImmutable();
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        @Override
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        @Override
        public String getPath() {
            return DefaultConfiguration.this.path.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.getIdentityPath() + "'";
        }

        @Override
        public FileCollection getFiles() {
            return new ConfigurationFileCollection(Specs.satisfyAll());
        }

        @Override
        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        @Override
        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        @Override
        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.decorateWithCurrent(action));
        }

        @Override
        public void beforeResolve(Closure action) {
            this.beforeResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.decorateWithCurrent(action));
        }

        @Override
        public void afterResolve(Closure action) {
            this.afterResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public ResolutionResult getResolutionResult() {
            return new LenientResolutionResult(DEFAULT_ERROR_HANDLER);
        }

        @Override
        public ArtifactCollection getArtifacts() {
            return new ConfigurationArtifactCollection();
        }

        @Override
        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            ArtifactViewConfiguration config = this.createArtifactViewConfiguration();
            configAction.execute(config);
            return this.createArtifactView(config);
        }

        private ArtifactView createArtifactView(ArtifactViewConfiguration config) {
            ImmutableAttributes viewAttributes = config.lockViewAttributes();
            boolean allowNoMatchingVariants = config.attributesUsed;
            return new ConfigurationArtifactView(viewAttributes, config.lockComponentFilter(), config.lenient, allowNoMatchingVariants);
        }

        private ArtifactViewConfiguration createArtifactViewConfiguration() {
            return DefaultConfiguration.this.instantiator.newInstance(ArtifactViewConfiguration.class, DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.configurationAttributes);
        }

        @Override
        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionResult getResolutionResult(Action<? super Throwable> errorHandler) {
            return new LenientResolutionResult(errorHandler);
        }

        private void assertArtifactsResolved() {
            DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        }

        private class LenientResolutionResult
        implements ResolutionResult {
            private final Action<? super Throwable> errorHandler;
            private volatile ResolutionResult delegate;

            private LenientResolutionResult(Action<? super Throwable> errorHandler) {
                this.errorHandler = errorHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void resolve() {
                if (this.delegate == null) {
                    LenientResolutionResult lenientResolutionResult = this;
                    synchronized (lenientResolutionResult) {
                        if (this.delegate == null) {
                            ConfigurationResolvableDependencies.this.assertArtifactsResolved();
                            this.delegate = DefaultConfiguration.this.cachedResolverResults.getResolutionResult();
                            ResolveException failure = DefaultConfiguration.this.cachedResolverResults.consumeNonFatalFailure();
                            if (failure != null) {
                                this.errorHandler.execute(failure);
                            }
                        }
                    }
                }
            }

            @Override
            public ResolvedComponentResult getRoot() {
                this.resolve();
                return this.delegate.getRoot();
            }

            @Override
            public Set<? extends DependencyResult> getAllDependencies() {
                this.resolve();
                return this.delegate.getAllDependencies();
            }

            @Override
            public void allDependencies(Action<? super DependencyResult> action) {
                this.resolve();
                this.delegate.allDependencies(action);
            }

            @Override
            public void allDependencies(Closure closure) {
                this.resolve();
                this.delegate.allDependencies(closure);
            }

            @Override
            public Set<ResolvedComponentResult> getAllComponents() {
                this.resolve();
                return this.delegate.getAllComponents();
            }

            @Override
            public void allComponents(Action<? super ResolvedComponentResult> action) {
                this.resolve();
                this.delegate.allComponents(action);
            }

            @Override
            public void allComponents(Closure closure) {
                this.resolve();
                this.delegate.allComponents(closure);
            }

            @Override
            public AttributeContainer getRequestedAttributes() {
                return this.delegate.getRequestedAttributes();
            }

            public int hashCode() {
                this.resolve();
                return this.delegate.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof LenientResolutionResult) {
                    this.resolve();
                    return this.delegate.equals(((LenientResolutionResult)obj).delegate);
                }
                return false;
            }

            public String toString() {
                return "lenient resolution result for " + this.delegate;
            }
        }

        private class ConfigurationArtifactView
        implements ArtifactView {
            private final ImmutableAttributes viewAttributes;
            private final Spec<? super ComponentIdentifier> componentFilter;
            private final boolean lenient;
            private final boolean allowNoMatchingVariants;

            ConfigurationArtifactView(ImmutableAttributes viewAttributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants) {
                this.viewAttributes = viewAttributes;
                this.componentFilter = componentFilter;
                this.lenient = lenient;
                this.allowNoMatchingVariants = allowNoMatchingVariants;
            }

            @Override
            public AttributeContainer getAttributes() {
                return this.viewAttributes;
            }

            @Override
            public ArtifactCollection getArtifacts() {
                return new ConfigurationArtifactCollection(this.viewAttributes, this.componentFilter, this.lenient, this.allowNoMatchingVariants);
            }

            @Override
            public FileCollection getFiles() {
                return new ConfigurationFileCollection(Specs.satisfyAll(), this.viewAttributes, this.componentFilter, this.lenient, this.allowNoMatchingVariants);
            }
        }
    }

    private class ConfigurationFileCollection
    extends AbstractFileCollection {
        private final Spec<? super Dependency> dependencySpec;
        private final AttributeContainerInternal viewAttributes;
        private final Spec<? super ComponentIdentifier> componentSpec;
        private final boolean lenient;
        private final boolean allowNoMatchingVariants;
        private SelectedArtifactSet selectedArtifacts;

        private ConfigurationFileCollection(Spec<? super Dependency> dependencySpec) {
            DefaultConfiguration.this.assertIsResolvable();
            this.dependencySpec = dependencySpec;
            this.viewAttributes = DefaultConfiguration.this.configurationAttributes;
            this.componentSpec = Specs.satisfyAll();
            this.lenient = false;
            this.allowNoMatchingVariants = false;
        }

        private ConfigurationFileCollection(Spec<? super Dependency> dependencySpec, AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean lenient, boolean allowNoMatchingVariants) {
            this.dependencySpec = dependencySpec;
            this.viewAttributes = viewAttributes.asImmutable();
            this.componentSpec = componentSpec;
            this.lenient = lenient;
            this.allowNoMatchingVariants = allowNoMatchingVariants;
        }

        private ConfigurationFileCollection(Closure dependencySpecClosure) {
            this(Specs.convertClosureToSpec(dependencySpecClosure));
        }

        private ConfigurationFileCollection(Set<Dependency> dependencies) {
            this(dependencies::contains);
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            DefaultConfiguration.this.assertIsResolvable();
            ResolverResults results = DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired();
            SelectedArtifactSet selected = results.getVisitedArtifacts().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants);
            FailureCollectingTaskDependencyResolveContext collectingContext = new FailureCollectingTaskDependencyResolveContext(context);
            selected.visitDependencies(collectingContext);
            if (!this.lenient) {
                DefaultConfiguration.this.rethrowFailure("task dependencies", collectingContext.getFailures());
            }
        }

        public Spec<? super Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        @Override
        public String getDisplayName() {
            return DefaultConfiguration.this.getDisplayName();
        }

        @Override
        public Set<File> getFiles() {
            ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor();
            this.visitContents(visitor);
            return visitor.getFiles();
        }

        @Override
        protected void visitContents(FileCollectionStructureVisitor visitor) {
            this.visitContents(new ResolvedFileCollectionVisitor(visitor));
        }

        private void visitContents(ResolvedFilesCollectingVisitor visitor) {
            this.getSelectedArtifacts().visitArtifacts(visitor, this.lenient);
            if (!this.lenient) {
                DefaultConfiguration.this.rethrowFailure("files", visitor.getFailures());
            }
        }

        private SelectedArtifactSet getSelectedArtifacts() {
            if (this.selectedArtifacts == null) {
                DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
                this.selectedArtifacts = DefaultConfiguration.this.cachedResolverResults.getVisitedArtifacts().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants);
            }
            return this.selectedArtifacts;
        }
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        @Override
        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }
}

