/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="XPathResponseHandler")
public final class XPathResponseHandler
extends SelectorBasedResponseHandler {
    private final Map<String, XPath> myCompiledCache = new HashMap<String, XPath>();

    public XPathResponseHandler() {
    }

    public XPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        Document document = new SAXBuilder(false).build((Reader)new StringReader(response));
        Element root = document.getRootElement();
        XPath xPath = this.lazyCompile(this.getSelector("tasks").getPath());
        List rawTaskElements = xPath.selectNodes((Object)root);
        if (!rawTaskElements.isEmpty() && !(rawTaskElements.get(0) instanceof Element)) {
            throw new Exception(String.format("Expression '%s' should match list of XML elements. Got '%s' instead.", xPath.getXPath(), rawTaskElements.toString()));
        }
        return ContainerUtil.getFirstItems((List)rawTaskElements, (int)max);
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        XPath xPath = this.lazyCompile(selector.getPath());
        String s = xPath.valueOf(context);
        if (s == null) {
            throw new Exception(String.format("XPath expression '%s' doesn't match", xPath.getXPath()));
        }
        return s;
    }

    @NotNull
    private XPath lazyCompile(@NotNull String path) throws Exception {
        XPath xPath = this.myCompiledCache.get(path);
        if (xPath == null) {
            try {
                xPath = XPath.newInstance((String)path);
                this.myCompiledCache.put(path, xPath);
            }
            catch (JDOMException e) {
                throw new Exception(String.format("Malformed XPath expression '%s'", path));
            }
        }
        return xPath;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        return ResponseType.XML;
    }
}

