/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.KotlinBinaryExtension;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000f\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014*\u00020\u0001\u001a\u0019\u0010\u0015\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0016*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n\u001a\n\u0010\u001d\u001a\u00020\u001a*\u00020\u001e\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiElement;", "getModule", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/module/Module;", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFileSystemItem;", "getSourceRoot", "(Lcom/intellij/psi/PsiFileSystemItem;)Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoots", "", "getSourceRoots", "(Lcom/intellij/openapi/module/Module;)[Lcom/intellij/openapi/vfs/VirtualFile;", "createPointer", "Lcom/intellij/openapi/module/ModulePointer;", "Lorg/jetbrains/annotations/NotNull;", "findModule", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "isInSourceContentWithoutInjected", "", "Lcom/intellij/openapi/roots/FileIndex;", "file", "isKotlinBinary", "Lcom/intellij/openapi/fileTypes/FileType;", "kotlin.core"})
public final class ProjectRootsUtilKt {
    public static final boolean isKotlinBinary(@NotNull FileType $this$isKotlinBinary) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinBinary, (String)"$this$isKotlinBinary");
        return KotlinBinaryExtension.Companion.getKotlinBinaries().contains($this$isKotlinBinary);
    }

    public static final boolean isInSourceContentWithoutInjected(@NotNull FileIndex $this$isInSourceContentWithoutInjected, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isInSourceContentWithoutInjected, (String)"$this$isInSourceContentWithoutInjected");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !(file instanceof VirtualFileWindow) && $this$isInSourceContentWithoutInjected.isInSourceContent(file);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull VirtualFile $this$getSourceRoot, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceRoot, (String)"$this$getSourceRoot");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        return projectRootManager.getFileIndex().getSourceRootForFile($this$getSourceRoot);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull PsiFileSystemItem $this$sourceRoot) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$sourceRoot, (String)"$this$sourceRoot");
        VirtualFile virtualFile2 = $this$sourceRoot.getVirtualFile();
        if (virtualFile2 != null) {
            Project project = $this$sourceRoot.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            virtualFile = ProjectRootsUtilKt.getSourceRoot(virtualFile2, project);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $this$rootManager) {
        Intrinsics.checkNotNullParameter((Object)$this$rootManager, (String)"$this$rootManager");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$rootManager);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager;
    }

    @NotNull
    public static final VirtualFile[] getSourceRoots(@NotNull Module $this$sourceRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceRoots, (String)"$this$sourceRoots");
        VirtualFile[] virtualFileArray = ProjectRootsUtilKt.getRootManager($this$sourceRoots).getSourceRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"rootManager.sourceRoots");
        return virtualFileArray;
    }

    @Nullable
    public static final Module getModule(@NotNull PsiElement $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"$this$module");
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)$this$module);
    }

    @Nullable
    public static final Module findModule(@NotNull VirtualFile $this$findModule, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findModule, (String)"$this$findModule");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ModuleUtilCore.findModuleForFile((VirtualFile)$this$findModule, (Project)project);
    }

    @NotNull
    public static final ModulePointer createPointer(@NotNull Module $this$createPointer) {
        Intrinsics.checkNotNullParameter((Object)$this$createPointer, (String)"$this$createPointer");
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)$this$createPointer.getProject()).create($this$createPointer);
        Intrinsics.checkNotNullExpressionValue((Object)modulePointer, (String)"ModulePointerManager.get\u2026nce(project).create(this)");
        return modulePointer;
    }
}

