/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import java.util.ArrayList;
import java.util.List;

public abstract class MethodBaseExpr
extends Expr {
    String mName;

    MethodBaseExpr(Expr parent, String name) {
        super(parent);
        this.mName = name;
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> targetPaths = this.getTarget().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (this.getTarget() instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, this.getTarget()));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", this.getTarget(), this.getModel().symbol("null", Object.class));
                cmp.setUnwrapObservableFields(false);
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                subPath.addPath(this);
                result.add(subPath);
            }
        }
        return result;
    }

    protected Expr resolveListenersAsMethodReference(ModelClass listener, Expr parent) {
        int numberOfAbstractMethods;
        Expr target = this.getTarget();
        ModelClass childType = target.getResolvedType();
        if (listener == null) {
            throw new IllegalStateException(String.format("Could not resolve %s as a listener.", this));
        }
        List<ModelMethod> abstractMethods2 = listener.getAbstractMethods();
        int n = numberOfAbstractMethods = abstractMethods2 == null ? 0 : abstractMethods2.size();
        if (numberOfAbstractMethods != 1) {
            throw new IllegalStateException(String.format("Could not find accessor %s.%s and %s has %d abstract methods, so is not resolved as a listener", childType.getCanonicalName(), this.mName, listener.getCanonicalName(), numberOfAbstractMethods));
        }
        ModelMethod listenerMethod = abstractMethods2.get(0);
        ModelClass[] listenerParameters = listenerMethod.getParameterTypes();
        boolean isStatic = this.getTarget() instanceof StaticIdentifierExpr;
        List<ModelMethod> methods = childType.findMethods(this.mName, isStatic);
        ModelClass listenerMethodReturnType = listenerMethod.getReturnType(null);
        boolean listenerIsKotlinUnit = listenerMethodReturnType.isKotlinUnit();
        for (ModelMethod method : methods) {
            ModelClass methodReturnType;
            boolean returnTypesMatch;
            boolean parametersMatch = this.acceptsParameters(method, listenerParameters);
            if (!parametersMatch || !(returnTypesMatch = (methodReturnType = method.getReturnType(null)).equals(listenerMethodReturnType) || listenerIsKotlinUnit && methodReturnType.isVoid())) continue;
            target.getParents().remove(this);
            this.resetResolvedType();
            Expr listenerExpr = this.getModel().listenerExpr(this.getTarget(), this.mName, listener, listenerMethod);
            if (parent != null) {
                int index;
                while ((index = parent.getChildren().indexOf(this)) != -1) {
                    parent.getChildren().set(index, listenerExpr);
                }
            }
            if (this.getModel().mBindingExpressions.contains(this)) {
                this.getModel().bindingExpr(listenerExpr);
            }
            this.getParents().remove(parent);
            if (this.getParents().isEmpty()) {
                this.getModel().removeExpr(this);
            }
            return listenerExpr;
        }
        throw new IllegalStateException(String.format("Listener class %s with method %s did not match signature of any method %s", listener.getCanonicalName(), listenerMethod.getName(), this));
    }

    private boolean acceptsParameters(ModelMethod method, ModelClass[] listenerParameters) {
        ModelClass[] parameters = method.getParameterTypes();
        if (parameters.length != listenerParameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAssignableFrom(listenerParameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getTarget()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        try {
            Scope.enter(this);
            this.getResolvedType();
            super.updateExpr(modelAnalyzer);
        }
        finally {
            Scope.exit();
        }
    }
}

