/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInsight.completion.HtmlCompletionContributor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.NotNull;

public class HtmlSpellcheckingStrategy
extends SpellcheckingStrategy {
    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiComment) {
            return this.myCommentTokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            if (URLUtil.isDataUri((String)ElementManipulators.getValueText((PsiElement)element))) {
                return EMPTY_TOKENIZER;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute) {
                if (HtmlCompletionContributor.hasHtmlAttributesCompletion((PsiElement)element) && HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)((XmlAttribute)parent)).length > 0) {
                    return EMPTY_TOKENIZER;
                }
                XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
                if (descriptor != null && (descriptor.isEnumerated() || descriptor.isFixed())) {
                    return EMPTY_TOKENIZER;
                }
            }
            return this.myXmlAttributeTokenizer;
        }
        return EMPTY_TOKENIZER;
    }
}

