/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DictionarySuggestionProvider
extends PreferrableNameSuggestionProvider {
    private boolean active;

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean shouldCheckOthers() {
        return !this.active;
    }

    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element, PsiElement nameSuggestionContext, @NotNull Set<String> result) {
        if (!this.active || nameSuggestionContext == null) {
            return null;
        }
        String initial = DictionarySuggestionProvider.getText(nameSuggestionContext);
        if (initial == null) {
            return null;
        }
        String normalized = DictionarySuggestionProvider.normalize(initial);
        Project project = element.getProject();
        SpellCheckerManager manager = SpellCheckerManager.getInstance(project);
        DictionarySuggestionProvider.denormalize(initial, manager.getSuggestions(normalized)).stream().filter(newName -> RenameUtil.isValidName((Project)project, (PsiElement)element, (String)newName)).forEach(result::add);
        return SuggestedNameInfo.NULL_INFO;
    }

    @Nullable
    private static String getText(@NotNull PsiElement textElement) {
        String text = textElement.getText();
        if (textElement instanceof PsiNamedElement) {
            text = ((PsiNamedElement)textElement).getName();
        }
        return text;
    }

    @NotNull
    private static String normalize(@NotNull String text) {
        return StringUtil.unquoteString((String)text);
    }

    @NotNull
    private static Collection<String> denormalize(@NotNull String initial, @NotNull Collection<String> suggestions2) {
        if (!StringUtil.isQuotedString((String)initial)) {
            return suggestions2;
        }
        char quote = initial.charAt(0);
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>(suggestions2.size());
        for (String suggestion : suggestions2) {
            tmp.append(suggestion);
            StringUtil.quote((StringBuilder)tmp, (char)quote);
            result.add(tmp.toString());
            tmp.setLength(0);
        }
        return result;
    }
}

