/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventSerializer;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalEventsLogger
implements DataCollectorSystemEventLogger {
    @NonNls
    private final Logger myLogger = Logger.getLogger((String)"com.intellij.internal.statistic.uploader.events");

    public ExternalEventsLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            this.myLogger.addAppender((Appender)ExternalEventsLogger.newAppender(ExternalEventsLogger.getEventLogFile(logDirectory).getAbsolutePath()));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @NotNull
    public static FileAppender newAppender(@NotNull String directory) {
        FileAppender appender = new FileAppender();
        appender.setFile(directory);
        appender.setLayout((Layout)new PatternLayout("%m\n"));
        appender.setThreshold((Priority)Level.ALL);
        appender.setAppend(false);
        appender.activateOptions();
        return appender;
    }

    @NotNull
    private static File getEventLogFile(@NotNull String logDirectory) {
        return new File(logDirectory, "idea_statistics_uploader_events.log");
    }

    public void logSendingLogsStarted() {
        this.logEvent(new ExternalUploadStartedEvent(System.currentTimeMillis()));
    }

    public void logSendingLogsFinished(@NotNull String error) {
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error));
    }

    public void logSendingLogsFinished(@NotNull StatisticsResult.ResultCode code) {
        String error = code == StatisticsResult.ResultCode.SEND ? null : code.name();
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error));
    }

    public void logSendingLogsSucceed(@NotNull List<String> successfullySentFiles, int failed, int total) {
        this.logEvent(new ExternalUploadSendEvent(System.currentTimeMillis(), successfullySentFiles.size(), failed, total, successfullySentFiles));
    }

    @Override
    public void logErrorEvent(@NotNull String eventId, @NotNull Throwable exception) {
        this.logEvent(new ExternalSystemErrorEvent(System.currentTimeMillis(), eventId, exception));
    }

    private void logEvent(@NotNull ExternalSystemEvent event) {
        this.myLogger.info((Object)ExternalSystemEventSerializer.serialize(event));
    }

    @NotNull
    public static List<ExternalSystemEvent> parseEvents(@NotNull File directory) throws IOException {
        List<String> lines;
        File file = ExternalEventsLogger.getEventLogFile(directory.getAbsolutePath());
        List<String> list = lines = file.exists() ? Files.readAllLines(file.toPath()) : Collections.emptyList();
        if (!lines.isEmpty()) {
            ArrayList<ExternalSystemEvent> events = new ArrayList<ExternalSystemEvent>();
            for (String line : lines) {
                ExternalSystemEvent event = ExternalSystemEventSerializer.deserialize(line);
                if (event == null) continue;
                events.add(event);
            }
            return events;
        }
        return Collections.emptyList();
    }
}

