/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.connect.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.filters.LogEventBucketsFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFalseFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistConditions;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistLoader;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EventLogUploadSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final String SEND = "send";
    private static final String METADATA = "metadata";
    private static final String DICTIONARY = "dictionary";
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo) {
        this(recorderId, appInfo, TimeUnit.MINUTES.toMillis(10L));
    }

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        super(EventLogUploadSettingsService.getConfigUrl(recorderId, appInfo.getProductCode(), appInfo.getTemplateUrl(), appInfo.isTest()), appInfo, settingsCacheTimeoutMs);
        this.myApplicationInfo = appInfo;
    }

    @NotNull
    private static String getConfigUrl(@NotNull String recorderId, @NotNull String productCode, @NotNull String templateUrl, boolean isTest) {
        return String.format(templateUrl, recorderId, productCode);
    }

    @Override
    @Nullable
    public String getServiceUrl() {
        return this.getEndpointValue(SEND);
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getEndpointValue(DICTIONARY);
    }

    @Override
    public boolean isSettingsReachable() {
        return this.getExternalSettings() != null;
    }

    @Override
    public boolean isSendEnabled() {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null && settings.isSendEnabled();
    }

    @Override
    @NotNull
    public LogEventFilter getBaseEventFilter() {
        return new LogEventWhitelistFilter(EventLogUploadSettingsService.notNull(this.getWhitelistedGroups(), StatisticsWhitelistConditions.empty()));
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
        EventLogSendConfiguration configuration = this.getConfiguration(type);
        if (configuration == null) {
            DataCollectorDebugLogger logger = this.myApplicationInfo.getLogger();
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot find send configuration for '" + type + "' -> clean up log file");
            }
            return LogEventFalseFilter.INSTANCE;
        }
        return new LogEventCompositeFilter(new LogEventBucketsFilter(configuration.getBuckets()), base, LogEventSnapshotBuildFilter.INSTANCE);
    }

    private static StatisticsWhitelistConditions notNull(@Nullable StatisticsWhitelistConditions whitelist, @NotNull StatisticsWhitelistConditions defaultValue) {
        return whitelist != null ? whitelist : defaultValue;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        return this.myApplicationInfo;
    }

    @Nullable
    protected StatisticsWhitelistConditions getWhitelistedGroups() {
        String productUrl = this.getWhiteListProductUrl();
        if (productUrl == null) {
            return null;
        }
        EventLogConnectionSettings settings = this.myApplicationInfo.getConnectionSettings();
        return StatisticsWhitelistLoader.getApprovedGroups(productUrl, settings);
    }

    @NonNls
    @Nullable
    public String getWhiteListProductUrl() {
        String baseWhitelistUrl = this.getEndpointValue(METADATA);
        if (baseWhitelistUrl == null) {
            return null;
        }
        return baseWhitelistUrl + this.myApplicationInfo.getProductCode() + ".json";
    }
}

