/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class StatisticsCachingSupplier<T>
implements Supplier<T> {
    private final long myTimeoutMs;
    @NotNull
    private final Supplier<? extends T> myValueSupplier;
    private long myLastCalcTime;
    private T myCache;

    public StatisticsCachingSupplier(@NotNull Supplier<? extends T> valueSupplier, long timeoutMs) {
        this.myTimeoutMs = timeoutMs;
        this.myValueSupplier = valueSupplier;
    }

    @Override
    public synchronized T get() {
        if (this.hasUpToDateValue()) {
            return this.myCache;
        }
        this.myCache = this.myValueSupplier.get();
        this.myLastCalcTime = System.currentTimeMillis();
        return this.myCache;
    }

    private synchronized boolean hasUpToDateValue() {
        return this.myTimeoutMs > System.currentTimeMillis() - this.myLastCalcTime;
    }
}

