/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.diagnostic.PluginException;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.psi.xml.XmlNamedReferenceHost;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XmlNamedReferenceProviderBean
extends CustomLoadingExtensionPointBean<PsiSymbolReferenceProvider> {
    @Property(surroundWithTag=false)
    @XCollection(elementName="hostName", valueAttributeName="")
    public String[] hostNames;
    @Tag
    public boolean caseSensitive = true;
    @Attribute
    @RequiredElement
    public String hostElementClass;
    @Attribute
    @RequiredElement
    public String targetClass;
    @Attribute
    @RequiredElement
    public String implementationClass;

    public String @NotNull [] getHostNames() {
        String[] names = this.hostNames;
        if (names == null || names.length == 0) {
            throw new PluginException("At least one host name must be specified", this.getPluginDescriptor().getPluginId());
        }
        return names;
    }

    @Override
    @Nullable
    protected String getImplementationClassName() {
        return this.implementationClass;
    }

    @NotNull
    public Class<? extends XmlNamedReferenceHost> getHostElementClass() {
        return this.loadClass(this.hostElementClass);
    }

    @NotNull
    public Class<? extends Symbol> getResolveTargetClass() {
        return this.loadClass(this.targetClass);
    }

    private <T> Class<T> loadClass(@NotNull String fqn) {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        try {
            return Class.forName(fqn, true, pluginDescriptor.getPluginClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(e, pluginDescriptor.getPluginId());
        }
    }
}

