/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import org.jetbrains.annotations.NotNull;

public class CommitId {
    @NotNull
    private final Hash myHash;
    @NotNull
    private final VirtualFile myRoot;

    public CommitId(@NotNull Hash hash, @NotNull VirtualFile root) {
        this.myHash = hash;
        this.myRoot = root;
    }

    @NotNull
    public Hash getHash() {
        return this.myHash;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitId commitId = (CommitId)o;
        if (!this.myHash.equals(commitId.myHash)) {
            return false;
        }
        return this.myRoot.equals(commitId.myRoot);
    }

    public int hashCode() {
        int result = this.myHash.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        return result;
    }

    public String toString() {
        return this.myHash.asString() + "(" + this.myRoot + ")";
    }
}

