/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public final class TimedDeadzone {
    public static final Length DEFAULT = new Length(150);
    public static final Length NULL = new Length(-1);
    private Length myLength = NULL;
    private boolean myMouseWithin;
    private long myTimeEntered = -1L;

    public TimedDeadzone(Length zoneLength) {
        this.myLength = zoneLength;
    }

    public int getLength() {
        return this.myLength.getLength();
    }

    public void enter(MouseEvent e) {
        if (this.myMouseWithin) {
            return;
        }
        this.myTimeEntered = e.getWhen();
        this.myMouseWithin = true;
    }

    public void clear() {
        this.myMouseWithin = false;
    }

    public boolean isWithin() {
        long now = System.currentTimeMillis();
        return this.myMouseWithin && now > this.myTimeEntered && now - this.myTimeEntered < (long)this.getLength();
    }

    public void setLength(@NotNull Length deadZone) {
        this.myLength = deadZone;
    }

    public static class Length {
        private final int myLength;

        public Length(int length) {
            this.myLength = length;
        }

        public int getLength() {
            return this.myLength;
        }
    }
}

