/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.JobQueue;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    private final List<MessageBusImpl> childBuses = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = Collections.emptyMap();

    CompositeMessageBus(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        super(owner, parentBus);
    }

    protected CompositeMessageBus(@NotNull MessageBusOwner owner) {
        super(owner);
    }

    @Override
    public final void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map) {
        if (this.topicClassToListenerDescriptor == Collections.emptyMap()) {
            this.topicClassToListenerDescriptor = map;
        } else {
            this.topicClassToListenerDescriptor.putAll(map);
            if (this.myRootBus != this) {
                this.myRootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    protected final boolean hasChildren() {
        return !this.childBuses.isEmpty();
    }

    final synchronized int @NotNull [] addChild(@NotNull MessageBusImpl bus) {
        int lastChildIndex;
        List<MessageBusImpl> children = this.childBuses;
        int n = lastChildIndex = children.isEmpty() ? 0 : ArrayUtil.getLastElement((int[])children.get((int)(children.size() - 1)).myOrder, (int)0);
        if (lastChildIndex == Integer.MAX_VALUE) {
            LOG.error("Too many child buses");
        }
        children.add(bus);
        return ArrayUtil.append((int[])this.myOrder, (int)(lastChildIndex + 1));
    }

    final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        boolean removed = this.childBuses.remove(childBus);
        this.myRootBus.myWaitingBuses.get().remove(childBus);
        CompositeMessageBus parentBus = this;
        do {
            parentBus.subscriberCache.clear();
        } while ((parentBus = parentBus.myParentBus) != null);
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    protected final MessageBusImpl.MessagePublisher createPublisher(@NotNull Topic<?> topic, Topic.BroadcastDirection direction) {
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new MessageBusImpl.ToParentMessagePublisher(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            if (this.myParentBus != null) {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
            }
            return new ToDirectChildrenMessagePublisher(topic, this);
        }
        return new MessageBusImpl.MessagePublisher(topic, this);
    }

    @Override
    @NotNull
    protected final List<Object> computeSubscribers(@NotNull Topic<?> topic) {
        if (this.owner.isDisposed()) {
            return Collections.emptyList();
        }
        return super.computeSubscribers(topic);
    }

    @Override
    protected final void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result, boolean subscribeLazyListeners) {
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers(topic, result, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers(topic, result, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private void subscribeLazyListeners(@NotNull Topic<?> topic) {
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        List<ListenerDescriptor> listenerDescriptors = this.topicClassToListenerDescriptor.remove(topic.getListenerClass().getName());
        if (listenerDescriptors == null) {
            return;
        }
        LinkedHashMap<PluginId, List> listenerMap = new LinkedHashMap<PluginId, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor.getPluginId(), __ -> new ArrayList()).add(this.owner.createListener(listenerDescriptor));
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((key, listeners) -> this.mySubscribers.add(new DescriptorBasedMessageBusConnection((PluginId)key, topic, (List<Object>)listeners)));
    }

    @Override
    protected final void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    @Override
    protected final void clearSubscriberCacheRecursively(@Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> topic) {
        CompositeMessageBus.clearSubscriberCache(this, handlers, topic);
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCacheRecursively(handlers, topic));
    }

    @Override
    final boolean notifyConnectionTerminated(Object[] topicAndHandlerPairs) {
        boolean isChildClearingNeeded = super.notifyConnectionTerminated(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
        SortedSet<MessageBusImpl> waitingBuses = this.myRootBus.myWaitingBuses.get();
        if (!waitingBuses.isEmpty()) {
            waitingBuses.removeIf(bus -> {
                JobQueue jobQueue = bus.myMessageQueue.get();
                return !jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> MessageBusConnectionImpl.removeHandlersFromJob(job, topicAndHandlerPairs) && job.handlers.isEmpty()) && jobQueue.current == null && jobQueue.queue.isEmpty();
            });
        }
        return false;
    }

    @Override
    protected final void clearSubscriberCache(Object[] topicAndHandlerPairs) {
        super.clearSubscriberCache(topicAndHandlerPairs);
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
    }

    @Override
    protected final void removeChildConnectionsRecursively(@NotNull Topic<?> topic, @Nullable Object handlers) {
        this.childBuses.forEach(childBus -> childBus.removeChildConnectionsRecursively(topic, handlers));
    }

    @Override
    protected final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        this.childBuses.forEach(MessageBusImpl::removeEmptyConnectionsRecursively);
    }

    @Override
    public final void clearPublisherCache() {
        this.publisherCache.clear();
        this.childBuses.forEach(childBus -> {
            if (childBus instanceof CompositeMessageBus) {
                ((CompositeMessageBus)childBus).clearPublisherCache();
            } else {
                childBus.publisherCache.clear();
            }
        });
    }

    @Override
    public final void unsubscribeLazyListeners(@NotNull PluginId pluginId, @NotNull List<ListenerDescriptor> listenerDescriptors) {
        if (listenerDescriptors.isEmpty() || this.mySubscribers.isEmpty()) {
            return;
        }
        HashMap<String, Set> topicToDescriptors = new HashMap<String, Set>();
        for (ListenerDescriptor descriptor : listenerDescriptors) {
            topicToDescriptors.computeIfAbsent(descriptor.topicClassName, __ -> new HashSet()).add(descriptor.listenerClassName);
        }
        boolean isChanged = false;
        ArrayList<DescriptorBasedMessageBusConnection> newSubscribers = null;
        Iterator connectionIterator = this.mySubscribers.iterator();
        while (connectionIterator.hasNext()) {
            List<Object> newHandlers;
            Set listenerClassNames;
            MessageBusImpl.MessageHandlerHolder holder = (MessageBusImpl.MessageHandlerHolder)connectionIterator.next();
            if (!(holder instanceof DescriptorBasedMessageBusConnection)) continue;
            DescriptorBasedMessageBusConnection connection = (DescriptorBasedMessageBusConnection)holder;
            if (connection.pluginId != pluginId || (listenerClassNames = (Set)topicToDescriptors.get(connection.topic.getListenerClass().getName())) == null || (newHandlers = DescriptorBasedMessageBusConnection.computeNewHandlers(connection.handlers, listenerClassNames)) == null) continue;
            isChanged = true;
            connectionIterator.remove();
            if (newHandlers.isEmpty()) continue;
            if (newSubscribers == null) {
                newSubscribers = new ArrayList<DescriptorBasedMessageBusConnection>();
            }
            newSubscribers.add(new DescriptorBasedMessageBusConnection(pluginId, connection.topic, newHandlers));
        }
        if (newSubscribers != null) {
            this.mySubscribers.addAll(newSubscribers);
        }
        if (isChanged) {
            if (this.myRootBus != this) {
                this.myRootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        super.disconnectPluginConnections(predicate);
        this.childBuses.forEach(bus -> bus.disconnectPluginConnections(predicate));
    }

    @Override
    public final void clearAllSubscriberCache() {
        LOG.assertTrue(this.myRootBus != this);
        this.myRootBus.subscriberCache.clear();
        this.subscriberCache.clear();
        this.childBuses.forEach(bus -> bus.subscriberCache.clear());
    }

    @Override
    protected final void disposeChildren() {
        this.childBuses.forEach(Disposer::dispose);
    }

    private static final class ToDirectChildrenMessagePublisher
    extends MessageBusImpl.MessagePublisher
    implements InvocationHandler {
        ToDirectChildrenMessagePublisher(@NotNull Topic<?> topic, @NotNull CompositeMessageBus bus) {
            super(topic, bus);
        }

        @Override
        protected final boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            List<Throwable> exceptions = null;
            boolean hasHandlers = false;
            List handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, this.bus::computeSubscribers);
            if (!handlers.isEmpty()) {
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, null);
                hasHandlers = true;
            }
            for (MessageBusImpl childBus : ((CompositeMessageBus)this.bus).childBuses) {
                if (childBus.owner.isDisposed() || (handlers = childBus.subscriberCache.computeIfAbsent(this.topic, topic1 -> {
                    ArrayList<Object> result = new ArrayList<Object>();
                    childBus.doComputeSubscribers((Topic<?>)topic1, (List<Object>)result, !childBus.owner.isParentLazyListenersIgnored());
                    return result.isEmpty() ? Collections.emptyList() : result;
                })).isEmpty()) continue;
                hasHandlers = true;
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            }
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }
    }
}

