/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

abstract class BaseBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    protected MessageBusImpl bus;
    protected final AtomicReference<Object[]> subscriptions = new AtomicReference<Object[]>(ArrayUtilRt.EMPTY_OBJECT_ARRAY);

    BaseBusConnection(@NotNull MessageBusImpl bus) {
        this.bus = bus;
    }

    public final <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler) {
        Object[] newList;
        Object[] list;
        do {
            if ((list = this.subscriptions.get()).length == 0) {
                newList = new Object[]{topic, handler};
                continue;
            }
            int size = list.length;
            newList = new Object[size + 2];
            System.arraycopy(list, 0, newList, 0, size);
            newList[size] = topic;
            newList[size + 1] = handler;
        } while (!this.subscriptions.compareAndSet(list, newList));
        this.bus.notifyOnSubscription(topic);
    }

    @Override
    public final void collectHandlers(@NotNull Topic<?> topic, @NotNull List<Object> result) {
        Object[] list = this.subscriptions.get();
        int n = list.length;
        for (int i = 0; i < n; i += 2) {
            if (list[i] != topic) continue;
            result.add(list[i + 1]);
        }
    }

    @Override
    public final void disconnectIfNeeded(@NotNull Predicate<Class<?>> predicate) {
        ArrayList<Object> newList;
        Object[] list;
        do {
            list = this.subscriptions.get();
            newList = null;
            for (int i = 0; i < list.length; i += 2) {
                if (predicate.test(list[i + 1].getClass())) {
                    if (newList != null) continue;
                    newList = new ArrayList<Object>(Arrays.asList(list).subList(0, i));
                    continue;
                }
                if (newList == null) continue;
                newList.add(list[i]);
                newList.add(list[i + 1]);
            }
            if (newList == null) {
                return;
            }
            if (!newList.isEmpty()) continue;
            this.disconnect();
            return;
        } while (!this.subscriptions.compareAndSet(list, newList.toArray()));
    }

    protected abstract void disconnect();

    @Override
    public final boolean isDisposed() {
        return this.bus == null;
    }

    public final String toString() {
        return Arrays.toString(this.subscriptions.get());
    }
}

