/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.HttpUrlConnectionUtil;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    private static final int[] REDIRECTS = new int[]{302, 307, 301, 303, 308};

    private HttpRequests() {
    }

    @NotNull
    public static RequestBuilder request(@NotNull Url url) {
        return HttpRequests.request(url.toExternalForm());
    }

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        return new RequestBuilderImpl(url, null);
    }

    @NotNull
    public static RequestBuilder head(@NotNull String url) {
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("HEAD"));
    }

    @NotNull
    public static RequestBuilder delete(@NotNull String url) {
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("DELETE"));
    }

    @NotNull
    public static RequestBuilder delete(@NotNull String url, @Nullable String contentType) {
        return HttpRequests.requestWithBody(url, "DELETE", contentType, null);
    }

    @NotNull
    public static RequestBuilder post(@NotNull String url, @Nullable String contentType) {
        return HttpRequests.requestWithBody(url, "POST", contentType, null);
    }

    @NotNull
    public static RequestBuilder put(@NotNull String url, @Nullable String contentType) {
        return HttpRequests.requestWithBody(url, "PUT", contentType, null);
    }

    @NotNull
    public static RequestBuilder patch(@NotNull String url, @Nullable String contentType) {
        return HttpRequests.requestWithBody(url, "POST", contentType, connection -> connection.setRequestProperty("X-HTTP-Method-Override", "PATCH"));
    }

    @NotNull
    private static RequestBuilder requestWithBody(@NotNull String url, @NotNull String requestMethod, @Nullable String contentType, @Nullable ConnectionTuner tuner) {
        return new RequestBuilderImpl(url, rawConnection -> {
            HttpURLConnection connection = (HttpURLConnection)rawConnection;
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (contentType != null) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (tuner != null) {
                tuner.tune(connection);
            }
        });
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) {
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return builder.toString();
    }

    /*
     * Loose catch block
     */
    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app == null || app.isUnitTestMode() || app.isHeadlessEnvironment() || !app.isReadAccessAllowed(), (Object)"Network shouldn't be accessed in EDT or inside read action");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader()) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader() {
        return SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        try (RequestImpl request = new RequestImpl(builder);){
            HttpURLConnection urlConnection;
            int responseCode;
            URLConnection connection;
            T result = processor.process(request);
            if (builder.myThrowStatusCodeException && (connection = request.myConnection) != null && connection.getDoOutput() && (responseCode = (urlConnection = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                HttpRequests.throwHttpStatusError(urlConnection, request, builder, responseCode);
            }
            T t = result;
            return t;
        }
    }

    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request) throws IOException {
        if (builder.myForceHttps && StringUtil.startsWith((CharSequence)request.myUrl, (CharSequence)"http:")) {
            request.myUrl = "https:" + request.myUrl.substring(5);
        }
        for (int i = 0; i < builder.myRedirectLimit; ++i) {
            String url;
            block22: {
                URLConnection connection;
                block20: {
                    int responseCode;
                    HttpURLConnection httpURLConnection;
                    block21: {
                        url = request.myUrl;
                        connection = !builder.myUseProxy ? new URL(url).openConnection(Proxy.NO_PROXY) : (ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url));
                        if (connection instanceof HttpsURLConnection) {
                            HttpRequests.configureSslConnection(url, (HttpsURLConnection)connection);
                        }
                        connection.setConnectTimeout(builder.myConnectTimeout);
                        connection.setReadTimeout(builder.myTimeout);
                        if (builder.myUserAgent != null) {
                            connection.setRequestProperty("User-Agent", builder.myUserAgent);
                        }
                        if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                            ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
                        }
                        if (builder.myGzip) {
                            connection.setRequestProperty("Accept-Encoding", "gzip");
                        }
                        if (builder.myAccept != null) {
                            connection.setRequestProperty("Accept", builder.myAccept);
                        }
                        connection.setUseCaches(false);
                        if (builder.myInternalTuner != null) {
                            builder.myInternalTuner.tune(connection);
                        }
                        if (builder.myTuner != null) {
                            builder.myTuner.tune(connection);
                        }
                        HttpRequests.checkRequestHeadersForNulBytes(connection);
                        if (!(connection instanceof HttpURLConnection)) {
                            return connection;
                        }
                        if (connection.getDoOutput()) {
                            return connection;
                        }
                        httpURLConnection = (HttpURLConnection)connection;
                        String method = httpURLConnection.getRequestMethod();
                        LOG.assertTrue(method.equals("GET") || method.equals("HEAD") || method.equals("DELETE"), (Object)("'" + method + "' not supported; please use GET, HEAD, DELETE, PUT or POST"));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("connecting to " + url);
                        }
                        try {
                            responseCode = httpURLConnection.getResponseCode();
                        }
                        catch (SSLHandshakeException e) {
                            throw !NetUtils.isSniEnabled() ? new SSLException("SSL error probably caused by disabled SNI", e) : e;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("response from " + url + ": " + responseCode);
                        }
                        if (responseCode >= 200 && (responseCode < 300 || responseCode == 304)) break block20;
                        if (ArrayUtil.indexOf((int[])REDIRECTS, (int)responseCode) < 0) break block21;
                        httpURLConnection.disconnect();
                        url = connection.getHeaderField("Location");
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("redirect from " + url + ": " + url);
                        }
                        if (url != null) break block22;
                    }
                    if (builder.myThrowStatusCodeException) {
                        HttpRequests.throwHttpStatusError(httpURLConnection, request, builder, responseCode);
                    }
                }
                return connection;
            }
            request.myUrl = url;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    private static void throwHttpStatusError(HttpURLConnection connection, RequestImpl request, RequestBuilderImpl builder, int responseCode) throws IOException {
        String message = null;
        if (builder.myIsReadResponseOnError) {
            message = HttpUrlConnectionUtil.readString(connection.getErrorStream(), connection);
        }
        if (StringUtil.isEmpty(message)) {
            message = "Request failed with status code " + responseCode;
        }
        connection.disconnect();
        throw new HttpStatusException(message, responseCode, StringUtil.notNullize((String)request.myUrl, (String)"Empty URL"));
    }

    private static void configureSslConnection(@NotNull String url, @NotNull HttpsURLConnection connection) {
        if (ApplicationManager.getApplication() == null) {
            LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
            return;
        }
        try {
            SSLSocketFactory factory = CertificateManager.getInstance().getSslContext().getSocketFactory();
            if (factory == null) {
                LOG.info("SSLSocketFactory is not defined by the IDE Certificate Manager; Using default SSL configuration to connect to " + url);
            } else {
                connection.setSSLSocketFactory(factory);
            }
        }
        catch (Throwable e) {
            LOG.info("Problems configuring SSL connection to " + url, e);
        }
    }

    private static void checkRequestHeadersForNulBytes(URLConnection connection) {
        block0: for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue.indexOf(0) < 0) continue;
                connection.setRequestProperty(header.getKey(), null);
                LOG.error(String.format("Problem during request to '%s'. Header's '%s' value contains NUL bytes: '%s'. Omitting this header.", connection.getURL().toString(), header.getKey(), headerValue));
                continue block0;
            }
        }
    }

    private static class RequestImpl
    implements Request,
    AutoCloseable {
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            return this.myUrl;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            return this.myConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                this.myInputStream = this.getConnection().getInputStream();
                if (this.myBuilder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                    this.myInputStream = CountingGZIPInputStream.create((InputStream)this.myInputStream);
                }
            }
            return this.myInputStream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            return this.getReader(null);
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                int contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()));
            }
            return this.myReader;
        }

        @NotNull
        private Charset getCharset() throws IOException {
            return HttpUrlConnectionUtil.getCharset(this.getConnection());
        }

        @Override
        public boolean isSuccessful() throws IOException {
            URLConnection connection = this.getConnection();
            return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
        }

        @Override
        public byte @NotNull [] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            return this.doReadBytes(indicator).toByteArray();
        }

        @NotNull
        private BufferExposingByteArrayOutputStream doReadBytes(@Nullable ProgressIndicator indicator) throws IOException {
            return HttpUrlConnectionUtil.readBytes(this.getInputStream(), this.getConnection(), indicator);
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            return HttpUrlConnectionUtil.readString(this.getInputStream(), this.getConnection(), indicator);
        }

        @Override
        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream byteStream = this.doReadBytes(indicator);
            if (byteStream.size() == 0) {
                return Strings.EMPTY_CHAR_SEQUENCE;
            }
            return this.getCharset().decode(ByteBuffer.wrap(byteStream.getInternalBuffer(), 0, byteStream.size()));
        }

        @Override
        @NotNull
        public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            FileUtilRt.createParentDirs((File)file);
            boolean deleteFile = true;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (int)this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    FileUtilRt.delete((File)file);
                }
            }
            return file;
        }

        @Override
        public void close() {
            StreamUtil.closeStream((Closeable)this.myInputStream);
            StreamUtil.closeStream((Closeable)this.myReader);
            if (this.myConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.myConnection).disconnect();
            }
        }
    }

    private static class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout = CONNECTION_TIMEOUT;
        private int myTimeout = READ_TIMEOUT;
        private int myRedirectLimit = REDIRECT_LIMIT;
        private boolean myGzip = true;
        private boolean myForceHttps;
        private boolean myUseProxy = true;
        private boolean myIsReadResponseOnError;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private final ConnectionTuner myInternalTuner;
        private boolean myThrowStatusCodeException = true;

        private RequestBuilderImpl(@NotNull String url, @Nullable ConnectionTuner internalTuner) {
            this.myUrl = url;
            this.myInternalTuner = internalTuner;
        }

        @Override
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder isReadResponseOnError(boolean isReadResponseOnError) {
            this.myIsReadResponseOnError = isReadResponseOnError;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
                return this.userAgent(productName + '/' + version);
            }
            return this.userAgent("IntelliJ");
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        @NotNull
        public RequestBuilder throwStatusCodeException(boolean shouldThrow) {
            this.myThrowStatusCodeException = shouldThrow;
            return this;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            return (T)HttpRequests.process(this, processor);
        }
    }

    public static class HttpStatusException
    extends IOException {
        private final int myStatusCode;
        private final String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        @Deprecated
        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        public byte @NotNull [] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        default public String readString() throws IOException {
            return this.readString(null);
        }

        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator var1) throws IOException;

        default public void write(@NotNull String data) throws IOException {
            this.write(data.getBytes(StandardCharsets.UTF_8));
        }

        default public void write(byte @NotNull [] data) throws IOException {
            HttpURLConnection connection = (HttpURLConnection)this.getConnection();
            connection.setFixedLengthStreamingMode(data.length);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(data);
            }
        }
    }
}

