/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UsageNodeTreeBuilder {
    private final GroupNode myRoot;
    private final Project myProject;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    UsageNodeTreeBuilder(UsageTarget @NotNull [] targets, UsageGroupingRule @NotNull [] groupingRules, UsageFilteringRule @NotNull [] filteringRules, @NotNull GroupNode root, @NotNull Project project) {
        this.myTargets = targets;
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
        this.myProject = project;
    }

    public void setGroupingRules(UsageGroupingRule @NotNull [] rules) {
        this.myGroupingRules = rules;
    }

    void setFilteringRules(UsageFilteringRule @NotNull [] rules) {
        this.myFilteringRules = rules;
    }

    public boolean isVisible(@NotNull Usage usage) {
        return Arrays.stream(this.myFilteringRules).allMatch(rule -> rule.isVisible(usage, this.myTargets));
    }

    UsageNode appendOrGet(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super Node> edtInsertedUnderQueue) {
        if (!this.isVisible(usage)) {
            return null;
        }
        boolean dumb = DumbService.isDumb(this.myProject);
        GroupNode groupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroupingRule rule = this.myGroupingRules[i];
            if (dumb && !DumbService.isDumbAware(rule)) continue;
            List<UsageGroup> groups = rule.getParentGroupsFor(usage, this.myTargets);
            for (UsageGroup group : groups) {
                groupNode = groupNode.addOrGetGroup(group, i, edtInsertedUnderQueue);
            }
        }
        return groupNode.addOrGetUsage(usage, filterDuplicateLines, edtInsertedUnderQueue);
    }
}

