/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.registry.Registry;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class PopupState
implements JBPopupListener,
PopupMenuListener {
    private final long threshold = Registry.intValue((String)"ide.popup.hide.show.threshold", (int)200);
    private boolean hidden = true;
    private long time;

    private void markAsShown() {
        this.hidden = false;
    }

    private void markAsHidden() {
        this.hidden = true;
        this.time = System.currentTimeMillis();
    }

    public boolean isRecentlyHidden() {
        if (!this.hidden) {
            return false;
        }
        this.hidden = false;
        return System.currentTimeMillis() - this.time < this.threshold;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void beforeShown(@NotNull LightweightWindowEvent event) {
        this.markAsShown();
    }

    @Override
    public void onClosed(@NotNull LightweightWindowEvent event) {
        this.markAsHidden();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
        this.markAsShown();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.markAsHidden();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent event) {
    }
}

